/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "delete_host.h"
#include "populate_host_treeview.h"
#include "select_first_host.h"
#include "populate_host_settings.h"
#include "reread_conf.h"

extern char DHCPD_CONF_BUF[1024];
extern char global_ipaddr[1024];
extern char global_hwaddr[1024];
extern char global_hostname[1024];



void apply_host_settings(struct w *widgets)
{
    FILE *fp;
    int new_host_def = 0;
    gchar *new_host_begin, *new_host_end;
    G_CONST_RETURN gchar *change_hostname, *change_ipaddr, *change_hwaddr;
    gchar *setting=NULL, *info;

    change_hostname = gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[0]));
    change_ipaddr = gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[1]));
    change_hwaddr = gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[2]));

    if( strlen(change_hostname) < 1 )
    {
        info = g_strdup_printf(_("Missing hostname, the host was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }
    if( strlen(change_ipaddr) < 7 )
    {
        info = g_strdup_printf(_("The IP-address is too short, the host was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }
    if( strlen(change_hwaddr) < 11 )
    {
        info = g_strdup_printf(_("The hardware address is too short, the host was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }

    /* Only update the scope treeview if the scope defs differs */
    if( strcmp(change_hostname, global_hostname) || strcmp(change_ipaddr, global_ipaddr) 
     || strcmp(change_hwaddr, global_hwaddr) )
      new_host_def = 1;

    new_host_begin = g_strdup_printf("host %s {\n    hardware ethernet %s;\n    fixed-address %s;\n", 
								      change_hostname,
							              change_hwaddr,
								      change_ipaddr);
    /* Added last */							
    new_host_end = g_strdup_printf("}\n");

    /* Delete the current host */
    delete_host(widgets);

    if((fp=fopen(DHCPD_CONF_BUF, "a"))==NULL)
    {
        printf("Could not open dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
	g_free(new_host_begin);
	g_free(new_host_end);
        return;
    }
    
    fputs(new_host_begin, fp);

    /* Default lease time */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[3])))>0 )
    {
        setting = g_strdup_printf("    default-lease-time %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[3])));
	fputs(setting, fp);
    }

    /* Max lease time */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[4])))>0 )
    {
        setting = g_strdup_printf("    max-lease-time %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[4])));
	fputs(setting, fp);
    }

    /* Domain name */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[5])))>0 )
    {
        setting = g_strdup_printf("    option domain-name \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[5])));
	fputs(setting, fp);
    }

    /* Subnet mask */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[6])))>0 )
    {
        setting = g_strdup_printf("    option subnet-mask %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[6])));
	fputs(setting, fp);
    }

    /* Broadcast address */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[7])))>0 )
    {
        setting = g_strdup_printf("    option broadcast-address %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[7])));
	fputs(setting, fp);
    }

    /* Broadcast address */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[8])))>0 )
    {
        setting = g_strdup_printf("    option routers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[8])));
	fputs(setting, fp);
    }

    /* Domain name servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[9])))>0 )
    {
        setting = g_strdup_printf("    option domain-name-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[9])));
	fputs(setting, fp);
    }

    /* NIS domain */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[10])))>0 )
    {
        setting = g_strdup_printf("    option nis-domain \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[10])));
	fputs(setting, fp);
    }

    /* Time offset */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[11])))>0 )
    {
        setting = g_strdup_printf("    option time-offset %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[11])));
	fputs(setting, fp);
    }

    /* NTP servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[12])))>0 )
    {
        setting = g_strdup_printf("    option ntp-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[12])));
	fputs(setting, fp);
    }

    /* Netbios name servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[13])))>0 )
    {
        setting = g_strdup_printf("    option netbios-name-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[13])));
	fputs(setting, fp);
    }

    /* Option T150 */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[14])))>0 )
    {
        setting = g_strdup_printf("    option T150 \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[14])));
	fputs(setting, fp);
    }

    /* Option filename */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[15])))>0 )
    {
        setting = g_strdup_printf("    filename \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[15])));
	fputs(setting, fp);
    }

    /* Option root-path */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[16])))>0 )
    {
        setting = g_strdup_printf("    option root-path \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->host_set_entry[16])));
	fputs(setting, fp);
    }

    fputs(new_host_end, fp);

    fclose(fp);

    if( setting!=NULL )
      g_free(setting);

    g_free(new_host_begin);
    g_free(new_host_end);

    /* Change the globals to new nic sub netmask if any */
    sprintf(global_hostname, "%s", change_hostname);
    sprintf(global_ipaddr, "%s", change_ipaddr);
    sprintf(global_hwaddr, "%s", change_hwaddr);

    /* Only update the host settings if the host defs differs */
    if( new_host_def )
    {
	populate_host_treeview(widgets);
	select_first_host(widgets);
	populate_host_settings(widgets);
    }

    reread_conf();
}
