#include <gtk/gtk.h>

#include "guioptionmenu.h"

gint gui_option_menu_get_selected(GtkWidget *option_menu)
{
	GSList *g;
	int i = -1, len = 0;

	g = gtk_radio_menu_item_group(((GtkRadioMenuItem *)(((GtkOptionMenu *)option_menu)->menu_item)));
	while(g) {
		if(((GtkCheckMenuItem *)(g->data))->active)
			i = len;
		len++;
		g = g->next;
	}

	return len - i - 1;
}

GtkWidget *gui_option_menu_new(GuiOptionMenu *gui_option_menu, int selected)
{
	GtkWidget *option_menu, *menu, *menu_item;
	GSList *group = NULL;
	int i;

	option_menu = gtk_option_menu_new();
	menu = gtk_menu_new();

	for(i=0; i<(gui_option_menu->size); i++) {
		menu_item = gtk_radio_menu_item_new_with_label(group, gui_option_menu->items[i].label);
		if(gui_option_menu->items[i].func)
			gtk_signal_connect(GTK_OBJECT(menu_item), "activate", gui_option_menu->items[i].func, gui_option_menu->items[i].data);
	
		group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menu_item));
		gtk_menu_append(GTK_MENU(menu), menu_item);
		if(i == selected)
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menu_item), TRUE);
		gtk_widget_show(menu_item);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU (option_menu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (option_menu), selected);

	return option_menu;
}
