#include "FSViewer.h"
#include "config.h"


proplist_t
GetDictObject(proplist_t dictKey, proplist_t valKey)
{
    proplist_t dict = NULL;
    proplist_t val  = NULL;

    if(dictKey && PLIsString(dictKey))
    {
	dict = PLGetDictionaryEntry(filesDB, dictKey);
	if(dict && PLIsDictionary(dict))
	{
	    if(valKey && PLIsString(valKey))
	    {
		val = PLGetDictionaryEntry(dict, valKey);
		if(val)
		    return val;
	    }
/* 	    else */
/* 		return dict; */
	}
    }

    return NULL;
} 

proplist_t
GetCmdForExtn(char *extn, char *cmd)
{
    proplist_t dictKey = PLMakeString(extn);
    proplist_t cmdKey  = PLMakeString(cmd);
    proplist_t val     = NULL;


    val = GetDictObject(dictKey, cmdKey);

    if(dictKey)
	PLRelease(dictKey);
    if(cmdKey)
	PLRelease(cmdKey);

    return val;
}

char *
GetExecStringForExtn(char *extn)
{
    proplist_t val = NULL;
    
    val = GetCmdForExtn(extn, "exec");
    
    if(val != NULL)
	return PLGetString(val);
    else
	return NULL;
}

char *
GetViewerStringForExtn(char *extn)
{
    proplist_t val = NULL;
    
    val = GetCmdForExtn(extn, "viewer");
    
    if(val != NULL)
	return PLGetString(val);
    else
	return NULL;
}

char *
GetEditorStringForExtn(char *extn)
{
    proplist_t val = NULL;
    
    val = GetCmdForExtn(extn, "editor");
    
    if(val)
	return PLGetString(val);
    else
	return NULL;
}

char *
GetIconStringForExtn(char *extn)
{
    proplist_t val = NULL;
    
    val = GetCmdForExtn(extn, "icon");
    
    if(val != NULL)
	return PLGetString(val);
    else
	return NULL;
}

proplist_t
FSRemoveArrayElement(proplist_t array, proplist_t val)
{
    int i;
    Bool notFound = True;

    if (array && PLIsArray(array)) 
    {
	for(i = 0; i < PLGetNumberOfElements(array); i++)
	{
	    if(PLIsEqual(val, PLGetArrayElement(array, i)))
	    {
		PLRemoveArrayElement(array, i);
		PLRelease(val);
		break;
	    }
	}
    }

    return array;
}

int
FSGetIntegerForName(char *name)
{
    return WMGetUDIntegerForKey(defaultsDB, name);
}   

void 
FSSetIntegerForName(char *name, int val)
{
    WMSetUDIntegerForKey(defaultsDB, val, name);
}   

void
FSSetStringForName(char *name, char *str)
{
    WMSetUDStringForKey(defaultsDB, str, name);
}

char *
FSGetStringForName(char *name)
{
    char *str;

    str = WMGetUDStringForKey(defaultsDB, name);

    if(str)
	return wstrdup(str);
    else
	return NULL;
}   

char *
FSGetStringForNameKey(char *name, char *key)
{
    proplist_t val  = NULL;
    proplist_t dict = NULL;

    dict = WMGetUDObjectForKey(defaultsDB, name);
    val  = FSGetDBObjectForKey(dict, key);

    if (!val)
        return NULL;

    if (!PLIsString(val))
        return NULL;

    return wstrdup(PLGetString(val));
}   

proplist_t 
FSGetDBObjectForKey(proplist_t dict, char *key)
{
    proplist_t val    = NULL;
    proplist_t valKey = PLMakeString(key);

    if(dict && PLIsDictionary(dict))
    {
	val = PLGetDictionaryEntry(dict, valKey);
    }    
    PLRelease(valKey);

    return val;
}

void
FSSetStringForNameKey(char *name, char *dictKey, char *str)
{
    proplist_t val  = NULL;
    proplist_t key  = NULL;
    proplist_t dict = NULL;

    val = PLMakeString(str);
    key = PLMakeString(dictKey);

    dict = WMGetUDObjectForKey(defaultsDB, name);
    if(dict)
	PLInsertDictionaryEntry(dict, key, val);
    else
	dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, name);
}   

proplist_t
FSGetArrayForNameKey(char *name, char *key)
{
    proplist_t val  = NULL;
    proplist_t dict = NULL;

    dict = WMGetUDObjectForKey(defaultsDB, name);
    val  = FSGetDBObjectForKey(dict, key);

    if (!val)
        return NULL;

    if (!PLIsArray(val))
        return NULL;

    return val;
}

Bool
InsertArrayElement(proplist_t array, proplist_t val)
{
    int i;
    Bool notFound = True;

    if (array && PLIsArray(array)) 
    {
	for(i = 0; i < PLGetNumberOfElements(array); i++)
	{
	    if(PLIsEqual(val, PLGetArrayElement(array, i)))
	    {
		notFound = False;
		break;
	    }
	}
	if(notFound)
	     PLAppendArrayElement(array, val);
    }
    else
	array = PLMakeArrayFromElements(val, NULL);

    return notFound;
}

void
InitFilesDB(FSViewer *fsViewer)
{
    proplist_t key   = NULL;
    proplist_t val   = NULL;
    proplist_t dict  = NULL;
    proplist_t array = NULL;

    /* App settings */
    WMSetUDStringForKey(defaultsDB, "FSViewer", "App");
    /* ROOT Settings */
    key = PLMakeString("icon");
    val = PLMakeString("mycomputer");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "ROOT");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* Default Folder setting */
    WMSetUDStringForKey(defaultsDB, "folder", "DIRECTORY");
    /* 
       Default Icon Directory 
       This is one of the place where the app looks for
       icons.  Check config.h for value.
    */
    WMSetUDStringForKey(defaultsDB, ICONDIR, "ICONDIR");
    /* Default File setting */
    WMSetUDStringForKey(defaultsDB, "file-plain", "DEFAULT_IMG");
    /* HOME setting */
    WMSetUDStringForKey(defaultsDB, "home", "HOME");

    /* Shelf Settings */
    array = PLMakeArrayFromElements( PLMakeString(wgethomedir()),
				     NULL );
    WMSetUDObjectForKey(defaultsDB, array, "SHELF");

    PLRelease(array);

    /* CONSOLE setting */
    key = PLMakeString("exec");
    val = PLMakeString("xterm");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "CONSOLE");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* PROCRESS setting */
    key = PLMakeString("exec");
    val = PLMakeString("xterm -exec top");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "PROCESS");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* DISKS setting */
/*     key = PLMakeString("devices"); */
    val = PLMakeArrayFromElements( PLMakeString("CDROM"), 
				   PLMakeString("/cdrom"), 
				   PLMakeString("/dev/hdc"),
				   PLMakeString("mount %s"),
				   PLMakeString("umount %s"),
				   PLMakeString("eject %s"),
				   PLMakeString("close %s"),
				   NULL );
    array = PLMakeArrayFromElements( val, NULL );
    wwarning("%s %d\n%s\n", __FILE__, __LINE__, 
	     PLGetDescriptionIndent(array, 0));
    WMSetUDObjectForKey(defaultsDB, array, "DISCS");
/*     dict = PLMakeDictionaryFromEntries(key, array, NULL); */

    PLRelease(array);
/*     PLRelease(key); */
    PLRelease(val);

/*     key = PLMakeString("mount"); */
/*     val = PLMakeString("mount %s"); */
/*     PLInsertDictionaryEntry(dict, key, val); */

/*     PLRelease(key); */
/*     PLRelease(val); */

/*     key = PLMakeString("umount"); */
/*     val = PLMakeString("umount %s"); */
/*     PLInsertDictionaryEntry(dict, key, val); */

/*     PLRelease(key); */
/*     PLRelease(val); */

/*     key = PLMakeString("eject"); */
/*     val = PLMakeString("eject %s"); */
/*     PLInsertDictionaryEntry(dict, key, val); */
/*     WMSetUDObjectForKey(defaultsDB, dict, "DISKS"); */

/*     PLRelease(key); */
/*     PLRelease(val); */
/*     PLRelease(dict); */

    /* Magic File file */
    WMSetUDStringForKey(defaultsDB, "MagicFiles", "MAGICFILE");
   
    /* Default Editor */
    key = PLMakeString("exec");
    val = PLMakeString("xedit %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "MAGICASCII");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* Default Image Viewer */
    key = PLMakeString("exec");
    val = PLMakeString("xv %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "MAGICIMAGE");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* Default Postscript Viewer */
    key = PLMakeString("exec");
    val = PLMakeString("ghostview %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, "MAGICPS");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    WMSetUDIntegerForKey(defaultsDB, 0, "DisplayDotFiles");
    WMSetUDIntegerForKey(defaultsDB, 0, "DisplayMCListPixmap");
    WMSetUDIntegerForKey(defaultsDB, 1, "DisplaySVBG");
    WMSetUDIntegerForKey(defaultsDB, 0, "SortOrder");
    WMSetUDIntegerForKey(defaultsDB, 0, "SortDisplay");
    WMSetUDIntegerForKey(defaultsDB, 169, "ColumnWidth");

    /* List of EXEs */
    array = PLMakeArrayFromElements( PLMakeString("xemacs"),
				     PLMakeString("netscape"),
				     PLMakeString("xv"),
				     PLMakeString("gimp"),
				     PLMakeString("xedit"),
				     NULL );
    WMSetUDObjectForKey(defaultsDB, array, "EXE");
    PLRelease(array);

    /* List of EXTNs */
    array = PLMakeArrayFromElements( PLMakeString(".html"),
				     PLMakeString(".shtml"),
				     PLMakeString(".phtml"),
				     PLMakeString(".pl"),
				     PLMakeString(".txt"),
				     PLMakeString(".java"),
				     PLMakeString(".cgi"),
				     PLMakeString(".sh"),
				     PLMakeString(".csh"),
				     PLMakeString(".dat"),
				     PLMakeString(".c"),
				     PLMakeString(".h"),
				     PLMakeString(".o"),
				     PLMakeString(".class"),
				     PLMakeString(".gz"),
				     PLMakeString(".tgz"),
				     PLMakeString(".bz2"),
				     PLMakeString(".rpm"),
				     PLMakeString(".png"),
				     PLMakeString(".zip"),
				     PLMakeString(".tif"),
				     PLMakeString(".xpm"),
				     PLMakeString(".jpg"),
				     PLMakeString(".gif"),
				     PLMakeString(".bmp"),
				     PLMakeString(".xbm"),
				     PLMakeString(".xpm"),
				     PLMakeString(".xcf"),
				     PLMakeString(".mp3"),
				     PLMakeString(".sh"),
				     PLMakeString(".csh"),
				     PLMakeString(".core"),
				     NULL );
    WMSetUDObjectForKey(defaultsDB, array, "EXTN");
    PLRelease(array);

    /* Netscape Settings */
    key = PLMakeString("exec");
    val = PLMakeString("netscape %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".html"),
				     PLMakeString(".shtml"),
				     PLMakeString(".phtml"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("netscape");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "netscape");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .html settings */
    key = PLMakeString("viewer");
    val = PLMakeString("netscape %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-html");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".html");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .shtml settings */
    key = PLMakeString("viewer");
    val = PLMakeString("netscape %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-html");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".shtml");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .phtml settings */
    key = PLMakeString("viewer");
    val = PLMakeString("netscape %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-html");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".phtml");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .htm settings */
    key = PLMakeString("viewer");
    val = PLMakeString("netscape %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-html");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".htm");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* XEmacs Settings */
    key = PLMakeString("exec");
    val = PLMakeString("xemacs %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".html"),
				     PLMakeString(".shtml"),
				     PLMakeString(".phtml"),
				     PLMakeString(".pl"),
				     PLMakeString(".txt"),
				     PLMakeString(".java"),
				     PLMakeString(".cgi"),
				     PLMakeString(".sh"),
				     PLMakeString(".csh"),
				     PLMakeString(".dat"),
				     PLMakeString(".c"),
				     PLMakeString(".h"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("xemacs");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "xemacs");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .txt settings */
    key = PLMakeString("viewer");
    val = PLMakeString("xedit %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xedit %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-txt");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".txt");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .cgi settings */
    key = PLMakeString("viewer");
    val = PLMakeString("xedit %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-executable");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".cgi");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .h settings */
    key = PLMakeString("viewer");
    val = PLMakeString("xemacs %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-h");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".h");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .o settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-o");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".o");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .java settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-java");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".java");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .class settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-class");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".class");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .gz settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-gz");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".gz");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .tgz settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-gz");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".tgz");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .tar.gz settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-gz");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".tar.gz");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .bz2 settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-bz2");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".bz2");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .rpm settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-rpm");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".rpm");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .png settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-png");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".png");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .zip settings */
    /* Phew, 'z' at last! */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-zip");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".png");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .tif settings */
    /* When did 't' start coming after 'z'??? */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-tif");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".tif");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .xpm settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-xpm");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".xpm");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .jpg settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-jpg");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".jpg");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .gif settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-gif");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".gif");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .bmp settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-bmp");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".bmp");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .xbm settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-xbm");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".xbm");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .xpm settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-xpm");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xv %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".xpm");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .xcf settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-xcf");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("gimp %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".xcf");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* Gimp Settings */
    key = PLMakeString("exec");
    val = PLMakeString("gimp %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".jpg"),
				     PLMakeString(".gif"),
				     PLMakeString(".bmp"),
				     PLMakeString(".xcf"),
				     PLMakeString(".xpm"),
				     PLMakeString(".xbm"),
				     PLMakeString(".png"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("wilber");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "gimp");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* xedit Settings */
    key = PLMakeString("exec");
    val = PLMakeString("xedit %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".txt"),
				     PLMakeString(".dat"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("file-dot-txt");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "xedit");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .dat settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-dat");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xedit %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".dat");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* XV Settings */
    key = PLMakeString("exec");
    val = PLMakeString("xv %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".jpg"),
				     PLMakeString(".gif"),
				     PLMakeString(".bmp"),
				     PLMakeString(".xpm"),
				     PLMakeString(".xbm"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("xv");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "xv");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .mp3 settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-mp3");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("mpg123 %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".mp3");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* mpg123 Settings */
    key = PLMakeString("exec");
    val = PLMakeString("mpg123 %s");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
    
    key = PLMakeString("extn");    
    array = PLMakeArrayFromElements( PLMakeString(".mp3"),
				     NULL );
    PLInsertDictionaryEntry(dict, key, array);

    PLRelease(key);
    PLRelease(array);

    key = PLMakeString("icon");
    val = PLMakeString("file-dot-mp3");
    PLInsertDictionaryEntry(dict, key, val);

    WMSetUDObjectForKey(defaultsDB, dict, "mp3");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .sh settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-sh");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".sh");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .csh settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-csh");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".csh");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .core settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-core");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);
    WMSetUDObjectForKey(defaultsDB, dict, ".core");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .c settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-c");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".c");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* ChangeLog settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-txt");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, "ChangeLog");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    /* .pl settings */
    key = PLMakeString("icon");
    val = PLMakeString("file-dot-pl");
    dict = PLMakeDictionaryFromEntries(key, val, NULL);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("editor");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);

    PLRelease(key);
    PLRelease(val);
   
    key = PLMakeString("viewer");
    val = PLMakeString("xemacs %s");
    PLInsertDictionaryEntry(dict, key, val);
    WMSetUDObjectForKey(defaultsDB, dict, ".pl");

    PLRelease(key);
    PLRelease(val);
    PLRelease(dict);

    WMSynchronizeUserDefaults(defaultsDB);
}

