/*  Copyright (C) 1999-2004 University of Oxford  */

/*  CCOPYRIGHT */

#include "options.h"

namespace Utilities {

  void OptionParser::usage()
  {
    cerr << endl << progname_ << endl << endl;
    cerr << "Usage: " << endl << example_ << endl;

    for(Options::iterator option = options_.begin(); option != options_.end(); 
	option++)
      {
	if((*option)->compulsory() && (*option)->visible()) {
	  static bool banner = true;
	  if(banner) {
	    cerr << endl << "Compulsory arguments (You MUST set one or more of):" << endl;
	    banner = false;
	  }
	  cerr << **option << endl;
	}
      }


    for(Options::iterator optionx = options_.begin(); optionx != options_.end(); 
	optionx++)
      {
	if(!(*optionx)->compulsory() && (*optionx)->visible()) {
	  static bool banner = true;
	  if(banner) {
	    cerr << endl << "Optional arguments (You may optionally specify one or more of):" << endl;
	    banner = false;
	  }
	  cerr << **optionx << endl;
	}
      }

    cerr << endl;
    cerr << endl;
  }

}
