/*
  (C) 2005 Vikas Gorur <vikasgp@gmail.com>
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.
    
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
    
  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301 USA
*/

#ifndef __FREETALK_H__
#define __FREETALK_H__

#include <loudmouth/loudmouth.h>
#include "util.h"

#define FT_GLOBAL_EXT_DIR   DATADIR "/" PACKAGE_NAME "/extensions"
#define FT_LOCAL_EXT_DIR    "." PACKAGE_NAME "/extensions" /* relative to $HOME */
#define FT_CONFIG_SCM        "." PACKAGE_NAME "/" PACKAGE_NAME ".scm"

enum foo {
  FT_DEAD = 0,
  FT_CONN,
  FT_AUTH
};

typedef struct {
  int argc;
  char **argv;
  char *server;
  char *jid_str;
  jid_t jid;
  char *password;
  char *current_buddy; /* autoinsertion */
  LmConnection *conn; /* = (LmConnection *) conn */
  char *prompt; /* "freetalk> " */
  GError *error;
  char need_ssl;
  unsigned short port;
  char daemon;
  char async_printf;
  enum foo conn_state;
  char *status_msg;
  GSList *roster;
  char *script;
  char *config_dir;
} ft_state;

extern ft_state state;

void interface_init (void);

#endif /* __FREETALK_H__ */
