/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://qt.nokia.com/contact.
**
**************************************************************************/

#ifndef FANCYACTIONBAR_H
#define FANCYACTIONBAR_H

#include <utils/global_exporter.h>

#include <QtCore/QMap>
#include <QtGui/QToolButton>

QT_BEGIN_NAMESPACE
class QMenu;
class QVBoxLayout;
QT_END_NAMESPACE

namespace Utils {
namespace Internal {

class FancyToolButton : public QToolButton
{
public:
    FancyToolButton(const QString &iconPath, QWidget *parent = 0);

    void paintEvent(QPaintEvent *event);
    QSize sizeHint() const;
    QSize minimumSizeHint() const;

private:
    const QMap<QString, QPicture> &m_buttonElements;
};

} // namespace Internal

class UTILS_EXPORT FancyActionBar : public QWidget
{
    Q_OBJECT

public:
    FancyActionBar(QWidget *parent = 0);

    void setSvgIconPath(const QString &iconpath) {m_IconPath=iconpath;}

    void paintEvent(QPaintEvent *event);
    void insertAction(int index, QAction *action, QMenu *menu = 0);

private slots:
    void toolButtonContextMenuActionTriggered(QAction*);

private:
    QVBoxLayout *m_actionsLayout;
    QString m_IconPath;
};

} // namespace Utils

#endif // FANCYACTIONBAR_H
