#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/script/fngen.py,v $
# Version:      @(#)$RCSfile: fngen.py,v $ $Revision: 1.1 $
#
#############################################################################
""" Generate Python code for Interface Repository objects. """


# Standard/built-in modules.
import sys, string

# Fnorb modules.
from Fnorb.orb      import CORBA, Util
from Fnorb.compiler import IDLCompiler


# Default options.
DEFAULT_DIRECTORY = '.' 
DEFAULT_PACKAGE   = Util.PackageName()
DEFAULT_GLOBALS   = '_GlobalIDL'


def main(argv):
    """ Do it. """

    # Default options.
    directory = DEFAULT_DIRECTORY
    package   = DEFAULT_PACKAGE
    globals   = DEFAULT_GLOBALS

    ifr_ids = []
    for arg in argv[1:]:
	# Output directory option.
	if arg[:12] == '--directory=':
	    directory = string.split(arg, '=')[1]

	# Package option.
	elif arg[:10] == '--package=':
	    package = Util.PackageName(string.split(arg, '=')[1])

	# Global IDL package option.
	elif arg[:10] == '--globals=':
	    globals = string.split(arg, '=')[1]

	# Interface repository ids.
	elif arg[:4] == 'IDL:':
	    ifr_ids.append(arg)

	# Ignore anything else (including the spurious last argument '\n' on
	# Windoows 95 ;^).
	else:
	    pass

    # Create the compilation context.
    context = IDLCompiler.Context(directory, package, globals)

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Get a reference to the IFR.
    ifr = orb.resolve_initial_references('InterfaceRepository')

    # Lookup the repository id(s) specified on the command line.
    contents = []
    for ifr_id in ifr_ids:
	ifr_object = ifr.lookup_id(ifr_id)
	if ifr_object._is_nil():
	    raise 'No definition found for id:', ifr_id

	contents.append(ifr_object)

    # Make sure we actually have something to do ;^)
    if len(contents) > 0:
	# Create an IDLCompiler to do the work!
	idl_compiler = IDLCompiler.IDLCompiler()

	# Generate code for the specified objects.
	idl_compiler.compile(context, contents)

    else:
	print 'Hmmm, generate nothing, I can do that ;^)'

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
