#! /usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997-2000
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
#
#      DSTC Pty Ltd
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
#
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Distributed Environment
# File:         $Source: /cvsroot/fnorb/fnorb/examples/threaded/client.py,v $
# Version:      @(#)$RCSfile: client.py,v $ $Revision: 1.4 $
#
#############################################################################
""" Client for the multi-threaded example. """


# Standard/built-in modules.
import sys, time, thread

# Fnorb modules.
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'.
import HelloWorld


class Client:

    def __init__(self, server, num_threads):
        """ Constructor. """

        self.__server = server
        self.__num_threads = num_threads
        self.__lk = thread.allocate_lock()

        return

    def start(self):
        """ Start the threads. """

        for i in range(self.__num_threads):
            thread.start_new_thread(self.__worker_thread, (i,))

        return

    def wait(self):
        """ Wait for all threads to complete. """

        self.__lk.acquire()
        num_threads = self.__num_threads
        self.__lk.release()

        while num_threads > 0:
            time.sleep(2)

            self.__lk.acquire()
            num_threads = self.__num_threads
            self.__lk.release()

        return

    #########################################################################
    # Private interface.
    #########################################################################

    def __worker_thread(self, thread_no):
        """ Worker thread. """

        print 'Thread:', thread_no, 'Started...'

        # Payload!
        payload = '\0' * 16000

        # Time 100 calls!
        start = time.time()
        for i in range(100):
            self.__server.hello_world(payload)
        end = time.time()

        print 'Thread:', thread_no, 'Time taken:', end - start

        self.__lk.acquire()
        self.__num_threads = self.__num_threads - 1
        self.__lk.release()

        thread.exit()


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)
    orb._fnorb_override_options({'Threading Model': 'Threaded'})

    # Read the server's stringified IOR from a file (this is just a 'cheap and
    # cheerful' way of locating the server - in practise the client would use
    # the naming or trader services).
    stringified_ior = open('Server.ref', 'r').read()

    # Convert the stringified IOR into an active object reference.
    server = orb.string_to_object(stringified_ior)

    # Create a client with 10 threads!
    client = Client(server, 10)

    # Start the threads.
    client.start()

    # Wait for them all to complete.
    client.wait()

    print 'All threads complete!'

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
