/*
 * FISG - Fast IRC Stats Generator
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _FISG_H
#define _FISG_H

#include "th_util.h"
#include <assert.h>

/*
 * Program name, version
 */
#define RA_NAME		"FISG"
#define RA_VERSION	"0.3.8"
#define RA_COPYRIGHT	"by ccr/TNSP (C) Copyright 2003 TNSP"
#define RA_FULLNAME	"Fast IRC Stats Generator"


/*
 * Configuration file section defines
 */
#define CFG_GEN_CHANNEL			"gen_channel"
#define CFG_GEN_IRCNET			"gen_ircnet"
#define CFG_GEN_MESSAGE			"gen_message"
#define CFG_GEN_DATEFORMAT		"gen_dateformat"
#define CFG_GEN_AUTO_FOLLOW_NICKS	"gen_auto_follow_nicks"
#define CFG_GEN_AUTO_FOLLOW_HEURISTIC	"gen_auto_follow_heuristics"
#define CFG_GEN_USER_FILE		"gen_user_file"

#define CFG_GEN_SHOWMAX			"gen_showmax"
#define CFG_GEN_SHOWMAX_DEF		(35)
#define CFG_GEN_SHOWREST		"gen_showrest"
#define CFG_GEN_SHOWREST_DEF		(20)

#define CFG_GEN_USE_PISG_SCORING	"gen_use_pisg_scoring"
#define CFG_GEN_STAT_ONLY_LISTED	"gen_stat_only_listed"

#define CFG_GEN_STAT_ACTIVE		"gen_stat_active_times"
#define CFG_GEN_STAT_TOP		"gen_stat_top_users"
#define CFG_GEN_STAT_ALMOST		"gen_stat_almost_top"
#define CFG_GEN_STAT_BIGNUM		"gen_stat_big_numbers"

#define CFG_GEN_STAT_TOP_HAPPY		"gen_stat_show_happiness"
#define CFG_GEN_STAT_TOP_COMMENT	"gen_stat_show_comment"
#define CFG_GEN_STAT_TOP_PICTURE	"gen_stat_show_picture"

#define DEF_GEN_DATEFORMAT		"%c"

/*
 * Settings
 */
#define SET_MAX_INFILES		(2048)
#define SET_MAX_NICKLEN		(32)
#define SET_HASH_MAXINDEX	(128)
#define SET_MAX_BUF		(2048)

#define	SET_HOURS_DAY		(24)
#define	SET_DAY_DIVISOR		(6)

#define SET_MIN_COMMENT_LEN	(10)
 
/*
 * Typedefs, structures
 */
typedef float	t_float;
typedef unsigned long int t_int;

typedef struct tusernode {
	/* Read from config */
	char	*userHandle;		/* Handle (real nick) */
	char	*picPath;		/* Path/filename of user's picture */
	char	*linkURL;		/* Link to homepages, etc. */
	BOOL	isManaged;		/* Managed user? */
	BOOL	isIgnored;		/* TRUE if user is ignored in stats */

	/* Calculated during parsing */
	t_int	nWords, nChars, nPublics, nCaps,
		nQuestions, nYelling,
		nKicks, nModeChanges, nTopicSets,
		nActions, nNotices, nGotKicked,
		nURLs, nJoins, nNickChanges;

	t_int	nWordsPerHour[SET_HOURS_DAY],
		nPublicsPerHour[SET_HOURS_DAY];

	char	*sComment;

	/* Computed after parsing */
	t_float	nWordsPerPublic,
		nCharsPerWord,
		nHappiness,
		nTotalScore,
		nCapsPercent,
		activityPercentPerHour[SET_HOURS_DAY];

	struct tusernode *pPrev, *pNext;
} t_user_entry;


typedef struct tnicknode {
	char nick[SET_MAX_NICKLEN];

	t_int	nUsed;		/* Times this nick has been referenced, */
				/* can be used in heuristic deduction of preferred nick */

	t_user_entry *user;	/* User that owns this nick */

	struct tnicknode *pPrev, *pNext;
} t_nick_entry;


typedef struct {
	/* Computed during parsing */
	t_user_entry *userList;
	t_nick_entry *nickList[SET_HASH_MAXINDEX];

	t_int nLines, nChars, nLogFiles, nDays;
	
	/* Computed after parsing */
	t_user_entry **userIndex;
	long int nUsers, nIgnored;

	t_user_entry
		*mostStupid,
		*mostLoud,
		*mostActions,
		*mostNotices,
		*mostModes,
		*mostKicks,
		*mostKicked,
		*mostCaps,
		*mostHappy,
		*mostSad,
		*mostURLs,
		*mostJoins;

	t_int	nTimeElapsed;
	t_float	activityPercentPerHour[SET_HOURS_DAY];
	int	activityPeak;
} t_stats;


typedef struct {
	int		iMode;
	BOOL		isSet;
	t_user_entry	*pUser;
} t_mode;


typedef struct {
	int	dYear, dMonth, dDay;
	int	tHours, tMinutes, tSeconds;
	t_user_entry	*pUser, *pUser2;
	t_mode	setModes[16];
	char	pText[SET_MAX_BUF + 1];
} t_lineinfo;


/*
 * Functions
 */
t_user_entry	*user_new(char *userHandle);
void		user_free(t_user_entry *pUser);
t_nick_entry	*nick_new(char *newNick);
void		nick_free(t_nick_entry *pNick);
void		user_insert(t_user_entry **userList, t_user_entry *pNode);
void		user_delete(t_user_entry **userList, t_user_entry *pNode);
int		nick_insert(t_nick_entry *nickList[], t_nick_entry *pNode);
t_user_entry	*user_search(t_nick_entry *nickList[], char *findNick);
void		nick_change(t_nick_entry *nickList[], t_user_entry *pFind, t_user_entry *pNew);
void		FERR(const char *, ...);

#endif /* _FISG_H */
