<refentry>

<refmeta>
  <refentrytitle>ocamlfind</refentrytitle>
  <manvolnum>1</manvolnum>
  <refmiscinfo>The findlib package manager for OCaml</refmiscinfo>
</refmeta>

<refnamediv id="ocamlfind">
  <refname>ocamlfind</refname>
  <refpurpose>[Command-line interface of the Package manager]</refpurpose>
</refnamediv>


<refsynopsisdiv>
<title>SYNOPSIS</title>
<synopsis>
       <link linkend="ocamlfind.query">ocamlfind query [-help | other options] <replaceable>package_name</replaceable> ...</link>
   or: <link linkend="ocamlfind.ocamlc">ocamlfind ocamlc [-help | other options] <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.ocamlcp">ocamlfind ocamlcp [-help | other options] <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.ocamlmktop">ocamlfind ocamlmktop [-help | other options] <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.ocamlopt">ocamlfind ocamlopt [-help | other options] <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.install">ocamlfind install [-help | other options] <replaceable>package_name</replaceable> <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.remove">ocamlfind remove [-help | other options] <replaceable>package_name</replaceable></link>
   or: <link linkend="ocamlfind.guess">ocamlfind guess <replaceable>package_name</replaceable> <replaceable>file</replaceable> ...</link>
   or: <link linkend="ocamlfind.list">ocamlfind list</link>
   or: <link linkend="ocamlfind.printconf">ocamlfind printconf</link>
</synopsis>
</refsynopsisdiv>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.query">
  THE "query" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind query [ -predicates <replaceable>p</replaceable>  | 
                  -format <replaceable>f</replaceable> |
                  -long-format | 
                  -i-format |
                  -l-format | 
                  -a-format |
                  -o-format | 
                  -prefix <replaceable>p</replaceable> |
                  -separator <replaceable>s</replaceable> | 
                  -suffix <replaceable>s</replaceable> |
                  -descendants | 
                  -recursive  ] <replaceable>package</replaceable> ...
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
This command looks packages up, sorts them optionally, and prints
attributes of them. If the option -recursive is not specified, exactly
the packages given on the command line are looked up; if -recursive is
present, the packages and all their ancestors, or if -descendants is
present, too, all their descendants are printed.
</para>

<para>
Package lookup and the selection of the attributes of the packages can
be modified by specifying predicates; without a -predicates option the
empty set of predicates is used. Note that even the lookup is
influenced by the set of actual predicates as the "requires" variables
may be conditional.
</para>

<para>
What is printed about a package depends on the specified format; there
are a number of options that modify the format. Some formats denote
sets of values (such as -format %a), in which case multiple output
records are printed for every package. (It is even possible to specify
formats denoting the Cartesian product of sets, such as -format %a%o,
but this does not make sense.) Before the first output record the
prefix is printed, and the suffix after the last record. Between two
records the separator is printed.
</para>
</refsect2>

<refsect2>
<title>Options</title>

<variablelist>
<varlistentry>
<term>-predicates <replaceable>p</replaceable></term>
<listitem><para>Sets the set of actual predicates. The argument
  <replaceable>p</replaceable> is a list of predicate names separated
  by commas and/or whitespace. If multiple -predicates options are
  given, the union of all specified sets is effectively used.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-format <replaceable>f</replaceable></term>
<listitem><para>Sets the format to the string
  <replaceable>f</replaceable>. Characters preceded by a percent sign
  are interpreted as placeholders; all other characters mean
  themselves. The defined placeholders are listed below.
  The default format is "%d".
</para></listitem>
</varlistentry>
<varlistentry>
<term>-long-format</term>
<listitem><para>Sets the format such that all relevant variables are printed.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-i-format</term>
<listitem><para>Same as -format "-I %d", i.e. directory options for ocamlc are printed.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-l-format</term>
<listitem><para>Same as -format "-ccopt -L%d", i.e. directory options for the
linker backend are printed.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-a-format</term>
<listitem><para>Same as -format "%a", i.e. archive file names are printed.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-o-format</term>
<listitem><para>Same as -format "%o", i.e. linker options are printed.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-prefix <replaceable>p</replaceable></term>
<listitem><para>Sets the prefix that is printed before the first output record
  to the given string. The default prefix is the empty string.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-suffix <replaceable>s</replaceable></term>
<listitem><para>Sets the suffix that is printed after the last output record
  to the given string. The default suffix is the empty string.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-separator <replaceable>s</replaceable></term>
<listitem><para>Sets the separator that is printed between output records to
  the given string. The default separator is a linefeed character.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-recursive</term>
<listitem><para>Not only the packages given on the command line are queried
  but also all ancestors or descendants. If the option -descendants is
  specified, too, the descendants are printed, otherwise the
  ancestors. The packages are topologically sorted.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-descendants</term>
<listitem><para>This option has only an effect if -recursive is turned on,
  too. In this case, instead of the ancestors the descendants of the
  given packages are queried.
</para></listitem>
</varlistentry>
</variablelist>
</refsect2>

<refsect2>
<title>Placeholders meaningful in the -format option</title>

<variablelist>
<varlistentry>
<term>%p</term>
  <listitem><para>Replaced by the package name</para></listitem>
</varlistentry>
<varlistentry>
<term>%d</term>
  <listitem><para>Replaced by the package directory</para></listitem>
</varlistentry>
<varlistentry>
<term>%v</term>
  <listitem><para>Replaced by the version string</para></listitem>
</varlistentry>
<varlistentry>
<term>%a</term>
  <listitem><para>Replaced by the archive filename. If there is more
  than one archive, a separate output record is printed for every archive.
</para></listitem>
</varlistentry>
<varlistentry>
<term>%A</term>
  <listitem><para>Replaced by the list of archive filenames.</para></listitem>
</varlistentry>
<varlistentry>
<term>%o</term>
  <listitem><para>Replaced by one linker option. If there is more than
  one option, a separate output record is printed for every option.
</para></listitem>
</varlistentry>
<varlistentry>
<term>%O</term>
  <listitem><para>Replaced by the list of linker options.</para></listitem>
</varlistentry>
</variablelist>
</refsect2>

</refsect1>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.ocamlc">
  <anchor id="ocamlfind.ocamlcp">
  <anchor id="ocamlfind.ocamlopt">
  <anchor id="ocamlfind.ocamlmktop">
  THE SUBCOMMANDS "ocamlc", "ocamlcp", "ocamlopt", and "ocamlmktop"
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind ( ocamlc | ocamlcp | ocamlopt | ocamlmktop )
          [ -package <replaceable>package-name-list</replaceable> |
            -linkpkg |
	    -predicates <replaceable>pred-name-list</replaceable> |
            -dontlink <replaceable>package-name-list</replaceable> |
	    -passopt <replaceable>arg</replaceable> |
	    <replaceable>standard-option</replaceable> ]
          <replaceable>file</replaceable> ...
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>

<para>
These subcommands are drivers for the compilers with the same names,
i.e. "ocamlfind ocamlc" is a driver for "ocamlc", and so on. The
subcommands understand all documented options of the compilers (here
called <replaceable>standard-options</replaceable>), but also a few
more options. If these subcommands are invoked only with standard
options, they behave as if the underlying compiler had been called
directly. The extra options modify this.
</para>

<para>
Internally, these subcommands transform the given list of options and
file arguments into an invocation of the driven compiler. This
transformation only adds options and files, and the relative order of
the options and files passed directly is unchanged.
</para>

<para>
If there are -package options, additional directory search specifiers
will be included ("-I", and "-ccopt -I"), such that files of all named
packages and all ancestors can be found.
</para>

<para>
The -linkpkg option causes that the packages listed in the -package
options and all necessary ancestors are linked in. This means that the
archive files implementing the packages are inserted into the list of
file arguments.
</para>

<para>
As the package database is queried a set of predicates is needed. Most
predicates are set automatically, see below, but additional predicates
can be given by a -predicates option.
</para>
</refsect2>

<refsect2>
<title>Options</title>

<para>
Here, only the additional options not interpreted by the compiler but
by the driver itself, and options with additional effects are explained.
</para>

<variablelist>
<varlistentry>
<term>-package <replaceable>package-name-list</replaceable></term>
  <listitem><para>Adds the listed package names to the set of included
  packages. The package names may be separated by commas and/or
  whitespace. In the transformed command, for every package of the set
  of included packages and for any ancestor a directory search option
  is inserted after the already given options. This means that
  "-I" and "-ccopt -I" options are added for every package directory.
  </para></listitem>
</varlistentry>
<varlistentry>
<term>-linkpkg</term>
  <listitem><para>Causes that in the transformed command all archives
  of the packages specified by -packages and all their ancestors are
  added to the file arguments. More precisely, these archives are
  inserted before the first given file argument. Furthermore, "-ccopt
  -L" options for all package directories, and the linker options of
  the selected packages are added, too. Note that the archives are
  inserted in topological order while the linker options are added in
  reverse toplogical order.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-predicates <replaceable>pred-name-list</replaceable></term>
  <listitem><para>Adds the given predicates to the set of actual
  predicates. The predicates must be separated by commas and/or
  whitespace. 
</para></listitem>
</varlistentry>
<varlistentry>
<term>-dontlink <replaceable>package-name-list</replaceable></term>
  <listitem><para>This option modifies the behaviour of
  -linkpkg. Packages specified here and all ancestors are not linked
  in. Again the packages are separated by commas and/or whitespace.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-passopt <replaceable>arg</replaceable></term>
  <listitem><para>The argument <replaceable>arg</replaceable> is
  passed directly to the underlying compiler. This is needed to
  specify undocumented compiler options.
</para></listitem>
</varlistentry>

<varlistentry>
<term>-verbose</term>
  <listitem><para>This standard option is interpreted by the driver, too.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-thread</term>
  <listitem><para>This standard option causes that the predicate "mt"
  is added to the set of actual predicates.
</para></listitem>
</varlistentry>
<varlistentry>
<term>-p</term>
  <listitem><para>This standard option of "ocamlopt" causes that the
  predicate "gprof" is added to the set of actual predicates.
</para></listitem>
</varlistentry>

</variablelist>

</refsect2>

<refsect2>
<title>Predicates</title>

<variablelist>
<varlistentry>
<term>byte</term>
<listitem>
<para>
The "byte" predicate means that one of the bytecode compilers is
used. It is automatically included into the predicate set if the
"ocamlc", "ocamlcp", or "ocamlmktop" compiler is used.
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>native</term>
<listitem>
<para>
The "native" predicate means that the native compiler is used. It is
automatically included into the predicate set if the "ocamlopt"
compiler is used.
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>toploop</term>
<listitem>
<para>
The "toploop" predicate means that the toploop is available in the
linked program. It is automatically included into the predicate set if
the "ocamlmktop" compiler is used.
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>mt</term>
<listitem>
<para>
The "mt" predicate means that the program is multi-threaded. It is
automatically included into the predicate set if the -thread option is
given. 
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>mt_posix</term>
<listitem>
<para>
The "mt_posix" predicate means that in the case "mt" is set, too, the
POSIX libraries are used to implement threads. "mt_posix" is automatically
included into the predicate set if the variable "type_of_threads" in the
META description of the "threads" package has the value "posix". This
is normally the case if "findlib" is configured for POSIX threads.
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>gprof</term>
<listitem>
<para>
The "gprof" predicate means that in the case "native" is set, too, the
program is compiled for profiling. It is automatically included into
the predicate set if "ocamlopt" is used and the -p option is in
effect.
</para>
</listitem>
</varlistentry>

<varlistentry>
<term>autolink</term>
<listitem>
<para>
The "autolink" predicate means that ocamlc is able to perform automatic
linking. It is automatically included into the predicate set if ocamlc
knows automatic linking (from version 3.00), but it is not set if the
-noautolink option is set.
</para>
</listitem>
</varlistentry>

</variablelist>

</refsect2>

<refsect2>
<title>Special behaviour of "ocamlmktop"</title>

<para>
As there is a special module <xref linkend="Topfind"
endterm="Topfind"> that supports loading of packages in scripts, the
"ocamlmktop" subcommand can add initialization code for this module.
This extra code is linked in if "findlib" is in the set of effectively
linked packages.
</para>

</refsect2>

<refsect2>
<title>How to set the names of the compiler executables</title>

<para> Normally, the O'Caml bytecode compiler can be called under the name
<literal>ocamlc</literal>. However, this is not always true; sometimes a
different name is chosen.</para>

<para> You can instruct ocamlfind to call executables with other names than
<literal>ocamlc</literal>, <literal>ocamlopt</literal>,
<literal>ocamlmktop</literal>, and <literal>ocamlcp</literal>. If present,
the environment variable <literal>OCAMLFIND_COMMANDS</literal> is interpreted
as a mapping from the standard names to the actual names of the executables. It
must have the following format:

<programlisting>
<replaceable>standardname1</replaceable>=<replaceable>actualname1</replaceable> <replaceable>standardname2</replaceable>=<replaceable>actualname2</replaceable> ...
</programlisting>
</para>

<para>Example: You may set <literal>OCAMLFIND_COMMANDS</literal> as follows:

<programlisting>
OCAMLFIND_COMMANDS='ocamlc=ocamlc-3.00 ocamlopt=ocamlopt-3.00'
export OCAMLFIND_COMMANDS
</programlisting>
</para>

<para>Alternatively, you can change the configuration file
<link linkend="findlib.conf">findlib.conf</link>.</para>
</refsect2>

</refsect1>

<!-- ********************************************************************** -->

<!--

<refsect1>
<title><anchor id="ocamlfind.use">
  THE "use" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind use [-p <replaceable>prefix</replaceable>] <replaceable>package_name</replaceable> ...
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>

<para>
This subcommand should not be used any longer. It is equivalent to the
"query" subcommand with -i-format and -separator " ".
</para>
</refsect2>
</refsect1>

-->

<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.install">
  THE "install" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind install [ -destdir <replaceable>directory</replaceable> ]
                  [ -metadir <replaceable>directory</replaceable> ]
                  [ -dont-add-directory-directive ]
                  <replaceable>package_name</replaceable> <replaceable>file</replaceable> ...
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
This subcommand installs a new package either at the default location
(see the variable <literal>destdir</literal> of
<link linkend="findlib.conf">findlib.conf</link>), or in the directory
specified by the -destdir option. This
means that a new package directory is created and that the files on
the command line are copied to this directory.
</para>

<para>
Note that package directories should be flat (no
subdirectories). Existing packages are never overwritten.
</para>

<para>
It is possible to have a separate directory for all the META files. If
you want that, you have either to set the variable
<literal>metadir</literal> of 
<link linkend="findlib.conf">findlib.conf</link>, or to specify the
-metadir option. In this case, the file called META is copied to the
specified directory and renamed to META.p (where p is the package
name), while all the other files are copied to the package
directory as usual. Furthermore, the META file is modified such that the
<literal>directory</literal> variable contains the path of the package
directory. 
</para>

<para> 
The option -dont-add-directory-directive prevents the installer from
adding a <literal>directory</literal> variable.
</para>

</refsect2>

</refsect1>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.remove">
  THE "remove" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind remove [ -destdir <replaceable>directory</replaceable> ]
                 [ -metadir <replaceable>directory</replaceable> ]
                 <replaceable>package_name</replaceable>
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
The package will removed if it is installed at the default location 
(see the variable <literal>destdir</literal> of
<link linkend="findlib.conf">findlib.conf</link>). If the package
resides at a different location, it will not be removed by default;
however, you can pass an alternate directory for packages by the
-destdir option. (This must be the same directory as specified at
installation time.)
</para> 

<para>
Note that package directories should be flat (no subdirectories); this
subcommand cannot remove deep package directories. 
</para>

<para>
If you have a separate directory for META files, you must either
configure this directory by the <literal>metadir</literal> variable
of <link linkend="findlib.conf">findlib.conf</link>, or by specifying
the -metadir option.
</para>

<para> 
The command does not fail if the package and/or the META
file cannot be located.
</para>

</refsect2>
</refsect1>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.guess">
  THE "guess" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind guess <replaceable>package_name</replaceable> <replaceable>file</replaceable> ...
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
This command is experimental: It tries to determine the META file by
inspecting the files to install for a package, and by comparing these
files with the current package base.
</para>

<para>
Simply call this command after you have built your library and before
you want to install it for the first time. The first argument must be
the package name, and the other arguments must be the files you are
going to install. The command inspects the .cmi and .cma/.cmxa files
and writes a META file to stdout. (Of course, it does not install any
of these files.)
</para>

<para>
Note that the generated META file is guessed and may be wrong.
</para>
</refsect2>
</refsect1>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.list">
  THE "list" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind list
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
This command lists all packages in the search path.
</para>
</refsect2>
</refsect1>


<!-- ********************************************************************** -->

<refsect1>
<title><anchor id="ocamlfind.printconf">
  THE "printconf" SUBCOMMAND
</title>

<refsect2>
<title>Synopsis</title>
<programlisting>
ocamlfind printconf
</programlisting>
</refsect2>

<refsect2>
<title>Description</title>
<para>
This command prints the effective configuration after reading the
configuration file, and after applying the various environment
variables overriding settings.
</para>
</refsect2>
</refsect1>



</refentry>




