extern GtkWidget *item;
extern GtkWidget *applet;
extern GtkWidget *frame;

enum itype {file, directory};

#define GCONF_KEY "/apps/file_menu_applet"

typedef struct _directory_menu directory_menu;
typedef struct _menu_item menu_item;

struct _directory_menu {
  time_t     mtime;         /* The last mtime we saw.  If this ever changes, invalidate the menu and all submenus. */
  char      *name;
  GtkWidget *dmenu;
  GtkWidget *tearoff;
};

struct _menu_item {
  enum itype      type;
  char      *name;
  char      *path;
  /*  GtkWidget *item; */
};

void doabout(AppletWidget * widget, gpointer data);
void show_directory_menu (GtkWidget *menu, void *path);
GtkWidget *pixmap_menu_item_new (const char *text, const GdkPixbuf *icon, int truncate);
GtkWidget *create_document_menu (char *file_path);
gboolean maybe_popup_menu (GtkWidget *widget, GdkEventButton *event, void *file_path);
void exec_document (void *file_path);
void remove_old_menus (GtkWidget *item, gpointer menu);
void show_preferences_menu ();

void set_drag_stuff_on_file_menu (GtkWidget *menuitem, gchar *full_path);

void exec_document_wrap (GtkWidget *widget, void *parent_menu);
void set_drag_stuff_on_directory_menu (GtkWidget *menuitem, gchar *full_path);
void set_drag_stuff_on_menu_bar (GtkWidget *bar);

void show_preferences_menu ();
void set_menu_title (GConfClient* client,
		     guint cnxn_id,
		     GConfEntry *entry,
		     gpointer user_data);
void change_watched_directory (GConfClient* client,
			       guint cnxn_id,
			       GConfEntry *entry,
			       gpointer user_data);
void change_cache_setting (GConfClient* client,
			   guint cnxn_id,
			   GConfEntry *entry,
			   gpointer user_data);

void restore_grabs (GtkWidget *w,gpointer data);

void show_rename_dialog (GtkWidget *menu, gchar *file_name);
void show_move_dialog (GtkWidget *menu, gchar *file_name);
void show_copy_dialog (GtkWidget *menu, gchar *file_name);
void delete_file (GtkWidget *w, char *fs );
void show_handler (GtkWidget *w, char *fs);
