/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  File-Roller
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <libgnomeui/gnome-propertybox.h>
#include <libgnomeui/gnome-pixmap.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-dialog-util.h>
#include <glade/glade.h>

#include "main.h"
#include "window.h"


#define GLADE_FILE "file_roller_prop.glade"


typedef struct {
	FRWindow  *window;

	GladeXML  *gui;
	GtkWidget *dialog;

	GtkWidget *show_hide_column[NUMBER_OF_COLUMNS]; /* checkbuttons */
	GtkWidget *history_len_spinbutton;
} DialogData;


/* called when the main dialog is closed. */
static void
destroy_cb (GtkWidget *widget, 
	    DialogData *data)
{
        gtk_object_unref (GTK_OBJECT (data->gui));
	g_free (data);
}


/* called when the "apply" button is clicked. */
static void
apply_cb (GtkWidget *widget, 
	  DialogData *data)
{
	/* Show/Hide Columns options. */

	preferences.show_name = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_NAME]));
	preferences.show_type = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_TYPE]));
	preferences.show_size = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_SIZE]));
	preferences.show_time = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_TIME]));
	preferences.show_path = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_PATH]));

	window_update_columns_visibility (data->window);

	/* History options. */

	preferences.max_history_len = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (data->history_len_spinbutton));

	gnome_property_box_changed (GNOME_PROPERTY_BOX (data->dialog));
}


/* called when the "ok" button is clicked. */
static void
ok_cb (GtkWidget *widget, 
       DialogData *data)
{
	apply_cb (widget, data);
	gtk_widget_destroy (data->dialog);
}


/* create the main dialog. */
void
dlg_preferences (GtkWidget *caller, FRWindow *window)
{
	DialogData *data;
	GtkWidget *btn_ok;
	GtkWidget *btn_cancel;
	GtkWidget *btn_apply;

	data = g_new (DialogData, 1);

	data->window = window;

	data->gui = glade_xml_new (GLADEDIR "/" GLADE_FILE , NULL);
        if (!data->gui) {
                g_warning ("Could not find " GLADE_FILE "\n");
		g_free (data);
                return;
        }

	/* Get the widgets. */

	data->dialog = glade_xml_get_widget (data->gui, "options_propertybox");

	data->show_hide_column[COLUMN_NAME] = glade_xml_get_widget (data->gui, "name_checkbutton");
	data->show_hide_column[COLUMN_TYPE] = glade_xml_get_widget (data->gui, "type_checkbutton");
	data->show_hide_column[COLUMN_SIZE] = glade_xml_get_widget (data->gui, "size_checkbutton");
	data->show_hide_column[COLUMN_TIME] = glade_xml_get_widget (data->gui, "time_checkbutton");
	data->show_hide_column[COLUMN_PATH] = glade_xml_get_widget (data->gui, "path_checkbutton");

        data->history_len_spinbutton = glade_xml_get_widget (data->gui, "history_len_spinbutton");

        btn_ok = GNOME_PROPERTY_BOX (data->dialog)->ok_button;
        btn_cancel = GNOME_PROPERTY_BOX (data->dialog)->cancel_button;
        btn_apply = GNOME_PROPERTY_BOX (data->dialog)->apply_button;

	/* Set widgets data. */
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_NAME]), preferences.show_name);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_TYPE]), preferences.show_type);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_SIZE]), preferences.show_size);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_TIME]), preferences.show_time);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->show_hide_column[COLUMN_PATH]), preferences.show_path);

	gtk_spin_button_set_value (GTK_SPIN_BUTTON (data->history_len_spinbutton),
				   (gfloat) preferences.max_history_len);

	/* Set the signals handlers. */

	gtk_signal_connect (GTK_OBJECT (data->dialog), "destroy",
			    (GtkSignalFunc) destroy_cb,
			    data);

	gtk_signal_connect (GTK_OBJECT (btn_ok), "clicked",
                            GTK_SIGNAL_FUNC (ok_cb),
                            data);
	gtk_signal_connect_after (GTK_OBJECT (btn_apply), "clicked",
				  GTK_SIGNAL_FUNC (apply_cb),
				  data);
	gtk_signal_connect_object (GTK_OBJECT (btn_cancel), "clicked",
				   GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   GTK_OBJECT (data->dialog));

	/* run dialog. */

	gnome_property_box_changed (GNOME_PROPERTY_BOX (data->dialog));
	gtk_window_set_transient_for (GTK_WINDOW (data->dialog), 
				      GTK_WINDOW (window->app));
	gtk_window_set_modal (GTK_WINDOW (data->dialog), TRUE);
	gtk_widget_show_all (data->dialog);
}
