#!/usr/bin/env python


"""FGo! - a simple GUI launcher for FlightGear Flight Simulator."""


import gettext
from sys import argv
from os import chdir
from Tkinter import Tk

from config import Config
from gui.mainwindow import App
from constants import LOCALE_DIR


gettext.install('fgo', LOCALE_DIR, unicode=True)


CLI_MESSAGE = """Usage: fgo
This program does not use command line options. Edit fgo/data/config/presets
file if you need to run FGo! with some pre-configurations."""


def run(working_dir):
    """Initialize application."""
    # Set current working directory.
    chdir(working_dir)

    root = Tk()
    root.title('FGo!')
    # Initialize data object.
    data = Config()
    promptToNotUseCli()
    # Initialize main window.
    app = App(root, data)

    # Set window resolution.
    window_geometry = data.window_geometry.get()
    if window_geometry:
        root.geometry(window_geometry)

    # Override window close button, so TerraSync
    # can be stopped before closing the program.
    root.protocol("WM_DELETE_WINDOW", app.quit)

    root.mainloop()

def promptToNotUseCli():
    if len(argv) > 1:
        print _(CLI_MESSAGE)

if __name__ == '__main__':
    from sys import path

    WORKING_DIR = path[0]
    run(WORKING_DIR)
