/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  time_Alarm.c */
/* class: Alarm */

#include <ferite.h>       /* we need this without a doubt */
#include "time_header.h"  /* this is the module header */

FE_NS_FUNCTION( time_Alarm_start )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        if( signal( SIGALRM, timer_sig_alarm ) == SIG_ERR )
        {
            ferite_error( script, "Couldn't set up alarm signal for timer.");
            FE_RETURN_VOID;
        }
        alarm( SelfObj->interval );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( time_Alarm_Alarm )
{
   char *functionName = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   double interval;
   double recurring;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 5, functionName, &interval, &recurring, &super, &self );

   { /* Main function body. */
 
        FeriteFunction	*func;

        func = __ferite_function_get( script, functionName );
        SelfObj = fmalloc(sizeof(AlarmData));
        SelfObj->function = func;
        SelfObj->interval = (long)interval;
        SelfObj->recurring = (long)recurring;
        SelfObj->timeleft = 0;
        currentAlarm = SelfObj;

        ffree( functionName );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( time_Alarm_stop )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        alarm(0);
        SelfObj->timeleft = 0;
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( time_Alarm_pause )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        SelfObj->timeleft = alarm(0);
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( time_Alarm_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        alarm(0);
        ffree( SelfObj );
    
   }
   FE_RETURN_VOID;
}

