/* Copyright (C) 20011126  Pete Vassoff <pfv@grex.org>
 * This code is released to the ferite project as below.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifdef STANDALONE_TEST
#include <stdio.h>
#endif
#ifdef DUFUS
#include <stdio.h>
#endif
#ifdef DUFUS2
#include <string.h>	// strstr() & friends.
#include <stdio.h>
#include <errno.h>
#endif
#include <string.h>             // for strrchr()
#include <limits.h>		// these 2 for realpath()
#include <stdlib.h>
#include <ferite.h>
#include "utility.h"
              
#include <sys/socket.h>		// for make & break usocks..
#include <sys/un.h>
#include <string.h>		// memcpy & friends

static const char *within;

void FileRecycle( FileData *fo )
{ int poop=0;
    if( fo->pathspec )	ffree( fo->pathspec );
    if( fo->modes )	ffree( fo->modes );

    if( fo->fp )
    {
    	fflush(fo->fp);
    	if(!fo->pipe)
    	{
	    if( fclose( fo->fp )<0 )
		poop=errno;
	}
	else
	{ int status;
	    status=pclose( fo->fp );
	    if( status == -1 )
	        poop=errno;
	    else
	    { // This is an undocumented-unfeature..
		status/=255;
		if(status==0x7F) poop= -2;
		//fprintf(stderr, "pclose==%02X; %d\n", status, poop);
	    }
	}
    }
    else if( fo->fd>=0 )
    {
	if( close( fo->fd )<0 )
	    poop=errno;
    }

    memset(fo, 0, sizeof(FileData) );
    fo->fd= -1;
    fo->err= poop;
}

int FileUmasking(char *mask, int *real)
{ int actual=0, older=0, newer=0;

     if(real)	 *real=0;
    
     if(mask && *mask)
     { char *ow, *gr, *ot;
	ow=gr=ot=0;
	ow=mask;
	gr= (strlen(mask)>3 ? mask+3 : 0);
	ot= (strlen(mask)>6 ? mask+6 : 0);
	actual=perm2int( ow, gr, ot);
	newer= masksense(actual);
     }
     older= umask(newer);
     if(real)	*real=actual;
     return older;
}


int nosort(const struct dirent **a, const struct dirent **b)
{
#ifdef STANDALONE_TEST
    fprintf(stderr, "a[%s], b[%s]\n", (**a).d_name, (**b).d_name);
#endif
    return 0;
}

int dironly(const struct dirent *a)
{ struct stat buf;
  char entire[2048];
  
    sprintf(entire, "%s/%s", within, a->d_name);
    lstat(entire, &buf);
    return S_ISDIR(buf.st_mode);
}

int fileonly(const struct dirent *a)
{ struct stat buf;
  char entire[2048];
  
    sprintf(entire, "%s/%s", within, a->d_name);
    lstat(entire, &buf);
    return S_ISREG(buf.st_mode);
}

int symlonly(const struct dirent *a)
{ struct stat buf;
  char entire[2048];
  
    sprintf(entire, "%s/%s", within, a->d_name);
    lstat(entire, &buf);
    return S_ISLNK(buf.st_mode);
}

int fifoonly(const struct dirent *a)
{ struct stat buf;
  char entire[2048];
  
    sprintf(entire, "%s/%s", within, a->d_name);
    lstat(entire, &buf);
    return S_ISFIFO(buf.st_mode);
}

int sockonly(const struct dirent *a)
{ struct stat buf;
  char entire[2048];
  
    sprintf(entire, "%s/%s", within, a->d_name);
    lstat(entire, &buf);
    return S_ISSOCK(buf.st_mode);
}


struct dirent **realscan(const char *path,
	int (*select)(struct dirent *),
	int (*compar)(struct dirent **, struct dirent **),
	int *count )
{ struct dirent **namelist=0;
  int n=0;
  char buffer[4096];

    if(realpath(path, buffer)==buffer)
    {
	//fprintf(stderr,"path[%s]\nbuffer[%s]\n", path, buffer);
	within= buffer;  
	n= scandir(path, &namelist, (void*)select, (void*)compar);
	within= 0;
    }
    if(count)
	*count=n;
    return namelist;

}

/* THIS IS FUCKED, BUT WHY??
void scancleanup( struct dirent ***given, int N)
{ struct dirent **at= *given;
  int i;

fprintf(stderr, "Running scancleanup(%p, %d)\n", *given, N);
    if(!*given)
    	return;
fprintf(stderr, "scancleanup(%d): PRE loop\n", N);
i=0;
    for(i=0; i<N; i++);
{fprintf(stderr, "free at[%d]=%p\n", i, at[i]);
	free(at[i]);
}fprintf(stderr, "scancleanup(%d): POST loop\n", N);
    free(at);
    *given=0;
}
*/

////////////////
int mkpath(const char *complete, mode_t mode)
{ char *buffer;
  int	n;

	if(!complete || !strcmp(complete,".") || !strcmp(complete, ".."))
		return 1;

	if( strrchr(complete, '/')==complete)
	{
		n= mkdir(complete, mode);
	}
	else
	{
		n= strrchr(complete, '/')-complete;
		buffer= (char*)malloc( n+2);
		memset(buffer, 0, n+1);
		strncpy(buffer, complete, n);
		mkpath(buffer, mode);
		n= mkdir(complete, mode);
		free(buffer);
	}
	return n;
} //end mkpath()

char *abspath( char *pathbuf, char *filebuf, const char *filepath)
{ char	*dynaHERE = getcwd(0,0),
	*dynaTHERE=0,
	*filename=0,
	*duplicate=0,
	*p;

    pathbuf[0]=0;
    if(filebuf) filebuf[0]=0;
    if(!pathbuf || !filepath)
    {
    	free( dynaHERE );
    	return 0;
    }

    duplicate= strdup(filepath);
    p= strrchr(duplicate, '/');
    if( p )
    {
//fprintf(stderr, "Filename is [%s]\n", p+1);
	if( strlen(p+1) )
	    filename= strdup(p+1);
    	if(filebuf && filename)
    	    strcpy(filebuf, filename);
    	*(p)=0; // this would be the filename..
    	if( duplicate[0] )
    	    chdir(duplicate);
    	dynaTHERE= getcwd(0, 0);
//fprintf(stderr, "It is located at [%s]\n", dynaTHERE);
    	chdir(dynaHERE);
	sprintf(pathbuf, "%s", dynaTHERE);	free(dynaTHERE);
	if(filename)
	{
	    strcat(pathbuf, "/");
	    strcat(pathbuf, filename);
	    free(filename);
	}
    }
    else if( strcmp(filepath,"..")==0 || strcmp(filepath, ".")==0 )
    {
	chdir(filepath);
    	getcwd(pathbuf, 8096);
//fprintf(stderr, "It is located at [%s]\n", pathbuf);
    	chdir(dynaHERE);
    }
    else
    {
	sprintf(pathbuf, "%s/%s", dynaHERE, filepath);
//fprintf(stderr, "Looks like [%s] is..\n\there:[%s]\n", filepath, dynaHERE);
    }
    if(duplicate)	free(duplicate);
    free(dynaHERE);
    return pathbuf;
}

// Convert a string of 3x [r-][w-][xsStT-] to an int.
unsigned perm2int(char *owner, char *group, char *other)
{ unsigned ret=0;

    if(owner)
    {
	ret|= (owner[0]=='r' ? 0400 : 0);
	ret|= (owner[1]=='w' ? 0200 : 0);
	switch(owner[2])
	{	case 's':	ret|=04000;
		case 'x':	ret|=0100;		break;
		case 'S':	ret|=04000;		break;
	}
    }
    if(group)
    {
	ret|= (group[0]=='r' ? 040 : 0);
	ret|= (group[1]=='w' ? 020 : 0);
	switch(group[2])
	{	case 's':	ret|=02000;
		case 'x':	ret|=010;		break;
		case 'S':	ret|=02000;		break;
	}
    }
    if(other)
    {
	ret|= (other[0]=='r' ? 04 : 0);
	ret|= (other[1]=='w' ? 02 : 0);
	switch(other[2])
	{	case 't':	ret|=01000;
		case 'x':	ret|=01;		break;
		case 'T':	ret|=01000;		break;
	}
    }
    return ret;
}

// These two functions allow us to create both client & server unix sockets.
// NOTE: The server-socket is a "passive listen-only endpoint", meaning you
// still need to accept() on it.
int breakSocket(char *name, int sockfd, int bound)
{
	close(sockfd);
	return (bound?unlink(name):1);
} /*end breakSocket() */

int makeSocket(char *name, int mask, int bound)
{ int	sockfd;
  int	oldmask;
  struct sockaddr_un *server, oursock;
  int tmp;

	/* We no longer have to expect caller to know of struct/pointers */
	server=&oursock;

	if(bound) /*server*/
	    unlink(name);

	/* Create socket */
	sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sockfd < 0)
	{
		return -1;
		//perror("opening stream socket");
		//exit(1);
	}

	/* Name socket using file system name */
	server->sun_family = AF_UNIX;
	strcpy(server->sun_path, name);


	/* process differently between servers and clients */
	if(bound) /*server*/
	{	

		oldmask=umask(masksense(mask));
		if(bind(sockfd, server, sizeof(struct sockaddr_un))) 
		{
			tmp=errno;
			close(sockfd);
			errno=tmp;
			return -1;
			//perror("binding stream socket");
			//exit(1);
		}
		umask(oldmask);


		/* Specify a Passive, Listen-only endpoint */
		if( listen(sockfd, 5) <0)
		{
			tmp=errno;
			close(sockfd);
			unlink(name);
			errno=tmp;
			return -1;
			//perror("Listen()");
			//exit(1);
		}
	}
	else /*client*/
	{

		if (connect(sockfd, server, sizeof(struct sockaddr_un)) < 0)
		{
			tmp=errno;
			close(sockfd);
			errno=tmp;
			return -1;
			//perror("Connect()");
			//exit(1);
		}
/*		printf("%i Socket has name %s\n", getpid(), server->sun_path);*/
	}
	/*printf("%i Socket has name %s\n", getpid(), server->sun_path);*/

	return sockfd;
} /*end makeSocket()*/

int poll_match(PollData *p, int what)
{ int i;
    for(i=0;i<p->total; i++) if(p->block[i].fd==what) break;
    return i;
}

void* poll_add(PollData *p, int handle, char *events)
{ int eventNum;
    if(!p->block)
    {
fprintf(stderr, "was EMPTY\n");
	p->block=fmalloc( sizeof(pollfd_t)*POLLBLK );
	if(!p->block)
	    return 0;
	p->active=0;
	p->total=POLLBLK;
    }
    if(p->active<p->total)
    { int i=poll_match(p, handle);
fprintf(stderr, "Matched or new..\n");
	eventNum=	strchr(events, 'r')? POLLIN  : 0;
	eventNum|=	strchr(events, 'w')? POLLOUT : 0;
	p->block[i].fd=handle;
	p->block[i].events=eventNum;
	if(i==p->active) p->active++;
    }
    if(p->active==p->total)
    { void *ret;
fprintf(stderr, "adding room..");
	ret= frealloc(p->block, sizeof(pollfd_t)*(p->active+POLLBLK) );
	if(ret)
	{
fprintf(stderr, "\tZero new elements..\n");
	    memset(&(p->block[p->active]), 0, sizeof(pollfd_t)*POLLBLK );
	    p->block=ret;
	    p->total+=POLLBLK;
	}
	else
	{
fprintf(stderr, "\tFailure to frealloc()..\n");
	    return ret;
	}
    }
    return p->block;
}

int poll_sort(PollData *p)
{ int i, j;
  pollfd_t *t;

    if(p->active)
    {
    	t=fmalloc( p->total*sizeof(pollfd_t) );
    	if(!t) return -1;
    	for(i=j=0;i<p->total; i++)
    	    if( p->block[i].revents )
    	    	memcpy( &t[j++], &p->block[i], sizeof(pollfd_t) );
    	for(i=0; i<p->total; i++)
    	    if( !p->block[i].revents )
    	    	memcpy( &t[j++], &p->block[i], sizeof(pollfd_t) );
	ffree(p->block);
	p->block=t;
    }
    return p->active;
}



#ifdef DUFUS
int main()
{ char boo[40];
	

	printf("make './t/e/s/t/test' ...%d\n",
		mkpath("./t/e/s/t/test", 0644) );
	printf("make './t/e/s/t/tack' ...%d\n",
		mkpath("./t/e/s/t/tack", 0644) );
	strcpy(boo, "./t/e/s/t/tack");
	printf("MAKE '%s' ...%d\n",
		boo, mkpath(boo, 0644) );


	return 0;
}
#endif //DUFUS

#ifdef DUFUS2
int main (int argc, char **argv)
{ char pathbuf[8096], fn[1024], *p;

    if(argc<2)
    	return printf("\n%s <pathspec>\n");
    
    if( abspath(pathbuf, fn, argv[1]) )
	printf("Got: [%s]+[%s]\n", pathbuf, fn);
    return 0;
}
#endif //DUFUS2
/////////////

#ifdef  STANDALONE_TEST
int main(int argc, char **argv)
{ struct dirent **ret;
  int N, i;

    ret=realscan(argv[1], (void*)0, (void*)alphasort, &N);
    printf("%d Entries:\n", N);
    for(i=0; i<N; i++)
    {
    	printf("%.2d [%s]\n", i, ret[i]->d_name );
    	free(ret[i]);
    }
    free(ret); ret=0;
    //scancleanup(&ret, N);
    printf("%p\n", ret);
}
#endif