/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_OPCODE_H__
#define __FERITE_OPCODE_H__

/* the instructions we have 
 * Note: all instructions opdata_* is a FeriteVariable *except* CALL_FUNC */

#define F_OP_NOP           0     /* no op */
#define F_OP_BINARY        1     /* call binary opcode->op with opcode->opdata_one & two as data items */
#define F_OP_UNARY         2     /* call unary operator opcode->op with op->opdata_one */
#define F_OP_FUNCTION      3     /* call a function (char *)opcode->opdata_one as the 
			          * object, (char *)opcode->opdata_two as the function
			          * job of called function to pull items off stack
			          * and then push it's result onto the stack */
#define F_OP_METHOD        4
#define F_OP_NEWOBJ        5
#define F_OP_JMP           6     /* just jump */
#define F_OP_EXIT          7     /* used as a return type thing =P ie to signal end of execution */
#define F_OP_PUSH          8
#define F_OP_PUSHVAR       9     /* push variable onto stack */
#define F_OP_POP           10    /* pop variable from stack -> ie to get rid of shit pushed onto the stack */
#define F_OP_BIE           11
#define F_OP_BNE           12    /* jump if the staus flag marks the old false, else ignore and continue */
#define F_OP_RGX           13
#define F_OP_ERR           14

#define OP_BINARY( ptr, opf, data1 ) \
   ptr->OP_TYPE = F_OP_BINARY;       \
   ptr->op = opf;                    \
   ptr->opdata = data1;              

#define OP_UNARY( ptr, opf, data1 )  \
   ptr->OP_TYPE = F_OP_UNARY;        \
   ptr->op = opf;                    \
   ptr->opdata = data1;                 

#define OP_PUSH( ptr, data1 )        \
   ptr->OP_TYPE = F_OP_PUSH;         \
   ptr->op = NULL;                   \
   ptr->opdata = data1;              

void __ferite_delete_opcode_list( FeriteScript *script, FeriteOpcodeList *oplist );
FeriteOpcodeList *__ferite_create_opcode_list( int size );
FeriteOp *__ferite_get_next_op( FeriteOpcodeList *list );
FeriteOp *__ferite_create_op(void);
FeriteOp *__ferite_current_op( FeriteOpcodeList *oplist );
FeriteOp *__ferite_get_next_op_address( FeriteOpcodeList *oplist );
int       __ferite_get_next_op_loc( FeriteOpcodeList *oplist ); /* same as __ferite_get_next_op_address
								 * but will return an index rather than 
								 * address :)
								 */
void __ferite_opcode_dump( FeriteOpcodeList *oplist );

#endif /* __FERITE_OPCODE_H__ */
