/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __FERITE_DEBUG_H__
#define __FERITE_DEBUG_H__

#ifdef DEBUG
# define _DEBUG
/* provides slower but more secure memory tracking */
# define FERITE_MEM_DEBUG 
# define FUD( var ) if(show_debug == 1) printf var ;
# define FE_ENTER_FUNCTION \
    int __ferite_depth = __ferite_call_level; \
    FUD(("|%s--> %s [line %d] Entering %s()\n", __ferite_stroflen(' ', (__ferite_call_level*2)), __FILE__, __LINE__, __FUNCTION__)); \
    __ferite_call_level++;

# define FE_LEAVE_FUNCTION( blim ) __ferite_call_level--; \
   FUD(("|%s<-- %s [line %d] Leaving  %s()\n", __ferite_stroflen(' ', (__ferite_call_level*2)), __FILE__, __LINE__, __FUNCTION__)); \
   if( __ferite_call_level != __ferite_depth ) { \
	  printf( "Depth Error: (file %s, line %d, function %s, depth=%d, expected %d)\n", __FILE__, __LINE__, __FUNCTION__, __ferite_call_level, __ferite_depth );  } \
   return blim;
#else
# define FUD( var )
# define FE_ENTER_FUNCTION 
# define FE_LEAVE_FUNCTION( blim ) return blim;
#endif

#define NOWT

#define FE_ASSERT( test ) \
     if( !(test) ) { \
		ferite_warning( NULL, "Assertion failed on line %d, %s: %s\n", __LINE__, __FILE__, #test ); \
		exit( -1 ); \
     }

extern int call_level;

#endif /* __FERITE_DEBUG_H__ */
