/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_COMPILER__
#define __FERITE_COMPILER__

#define FERITE_BLOCK_NOP          0
#define FERITE_BLOCK_CTRL         1
#define FERITE_BLOCK_VAR          2
#define IF_JUMP_THEN              3
#define IF_JUMP_ELSE              4
#define WHILE_JUMP_TO             5
#define WHILE_JUMP_BLOCK          6
#define FOR_TEST_START            7
#define FOR_JUMP_BLOCK            8
#define FOR_JUMP_INCR             9
#define FOR_INCR_START            10
#define DO_START                  11
#define DO_END                    12
#define ERR_START                 13
#define FIX_BLOCK_JMP             14
#define JMP_ERR_ELSE              15
#define SWITCH_CONTINUE_JUMP_TO   16
#define SWITCH_NEXT_CASE          17
#define SWITCH_NEXT_CASE_BLOCK    18

FeriteBkRequest *__ferite_create_request( FeriteOp *op, int type );
void __ferite_destroy_request( FeriteBkRequest *ptr );
  
int ferite_parse(void);
void ferite_prepare_parser( char *s );
void ferite_clean_parser(void);
FeriteScript *__ferite_compile_string( char *str );
void ferite_set_filename( char *name );
void ferite_save_lexer();
void ferite_restore_lexer();

void __ferite_do_load_module( char *name );
void __ferite_do_load_script( char *name );
void __ferite_script_include( FeriteScript *script, char *filename );
void __ferite_do_function_header( char *name, char *returntype, int is_static );
void __ferite_do_function_start();
void __ferite_do_function_footer();
void __ferite_do_class_header( char *name, char *extends );
void __ferite_do_class_footer();
void __ferite_do_namespace_header( char *name );
void __ferite_do_namespace_extends( char *name );
void __ferite_do_namespace_footer();
void __ferite_do_add_variable_to_paramlist( char *name, char *type );
void __ferite_do_add_variable( char *name, char *type, int is_global, int is_final, int is_static );
void __ferite_do_add_variable_with_value( char *name, FeriteVariable *new_variable, int is_global );

void __ferite_do_push( FeriteVariable *var );
void __ferite_do_pop();
void __ferite_do_variable_push( char *name );
void __ferite_do_binary_op( void *opptr );
void __ferite_do_unary_op( void *opptr );
void __ferite_do_function_call( char *name );
void __ferite_do_object_function_call( char *name );
void __ferite_do_exit();

void __ferite_do_if_statement();
void __ferite_do_after_then_statement();
void __ferite_do_after_then_before_else_statement();
void __ferite_do_after_else_statement();
    
void __ferite_do_while_begin();
void __ferite_do_while_after_expr();
void __ferite_do_while_end();

void __ferite_do_for_loop_start();
void __ferite_do_for_loop_itterate();
void __ferite_do_for_loop_block();
void __ferite_do_for_loop_end();

void __ferite_do_do_start();
void __ferite_do_do_end();

void __ferite_do_new_object();
void __ferite_do_regex( char *pattern );

void __ferite_do_iferr_block();
void __ferite_do_before_fix_block();
void __ferite_do_after_fix_block();
void __ferite_do_after_fix_before_else_block();
void __ferite_do_after_fix_else_statement();

void __ferite_do_pre_switch();
void __ferite_do_pre_case_block_start();
void __ferite_do_default_block_start();
void __ferite_do_case_block_start();
void __ferite_do_case_block_end();
void __ferite_do_post_switch();

void __ferite_do_break();
void __ferite_do_continue();
void __ferite_process_breaks( int starttag, int address );

void __ferite_clean_compiler();


/* ferite_execute.c */
void __ferite_clean_executor( FeriteScript *script );
void __ferite_stop_execution( FeriteScript *script );
int __ferite_is_executing( FeriteScript *script );

int __ferite_script_function_execute( FeriteScript *script, FeriteFunction *function, FeriteVariable **params );
int __ferite_script_real_function_execute( FeriteScript *script, FeriteFunction *function, FeriteNamespace *mainns, FeriteExecuteRec *exec );
void __ferite_clean_up_exec_rec( FeriteScript *script, FeriteExecuteRec *exec );
int __ferite_script_eval_execute( FeriteScript *script, FeriteFunction *function, FeriteNamespace *mainns, FeriteExecuteRec *exec );

FeriteVariable **__ferite_create_parameter_list( int size );
FeriteVariable **__ferite_add_to_parameter_list( FeriteVariable **list, FeriteVariable *var );
void __ferite_delete_parameter_list( FeriteScript *script, FeriteVariable **list );
FeriteVariable **__ferite_create_parameter_list_from_data( FeriteScript *script, char *format, ... );
FeriteVariable *__ferite_call_function( FeriteScript *script, FeriteFunction *function, FeriteVariable **params );

#endif /* __FERITE_COMPILER__ */
