/*
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <unistd.h>

static unsigned long
sim_log2(unsigned long x)
{
	unsigned int res;

	assert(x != 0);

	for (res = 0; x != 1; res++) {
		x >>= 1;
	}

	return res;
}

static unsigned char contents[256] = {
	/* 0x00: Number of bytes in SPD EEPROM. */
	0x80, /* -> 128 bytes used */
	/* 0x01: Size of EEPROM in bytes. */
	0x08, /* 256 bytes. */
	/* 0x02: Type of memory. */
	0x02, /* EDO. */
	/* 0x03: Number of address bits for row. */
	0x00,
	/* 0x04: Number of address bits for column. */
	0x00,
	/* 0x05: Number of Module Rows */
	1, /* FIXME VOSSI */
	/* 0x06: Module Data Width (Low Byte) */
	64, /* FIXME VOSSI */
	/* 0x07: Module Data Width (High Byte) */
	0, /* FIXME VOSSI */
	/* 0x08: SDRAM module signal voltage interface */
	0,
	/* 0x09: SDRAM cycle time (highest CAS latency) */
	0,
	/* 0x0a: SDRAM access time from clock */
	0,
	/* 0x0b: Module Configration Type */
	0, /* No parity, no ECC, no ... */
	/* 0x0c */
	0,
	/* 0x0d: SDRAM Width (Primary SDRAM). */
	64,
	/* 0x0e: Error Checking SDRAM Width */
	0, /* Undefined */ /* FIXME VOSSI */
	/* 0x10: SDRAM device attributes, burst length supported */
	0,
	/* 0x11: SDRAM Device Attributes, Number of Banks on 
	 *       SDRAM Device*/
	0,
	/* 0x12: SDRAM Device Attributes, CAS Latency */
	0x7f,
	/* 0x13: SDRAM Device Attributes, CS Latency */
	0,
	/* 0x14: SDRAM Device Attributes, WE Latency */
	0,
	/* 0x15: SDRAM Module Attributes */
		/* bit 7: TBD */
		/* bit 6: Redundant Row Addr */
		/* bit 5: Differential Clock Input */
		/* bit 4: Registered DQMB Inputs */
		/* bit 3: Buffered DQMB Inputs */
		/* bit 2: On-Card PLL (Clock) */
		/* bit 1: Registered Address/Control Inputs */
		/* bit 0: Buffered Address/Control Inputs */
	0,
	/* 0x16: SDRAM Device Attributes, general */
	0,
	/* 0x17: SDRAM Cycle time (2nd highest CAS latency) */
	(4 << 4) | (5 << 0), /* 4.5ns */
	/* 0x18: SDRAM Access from Clock (2nd highest CAS latency) */
	(4 << 4) | (5 << 0), /* 4.5ns */
	/* ... */
};

int
main(void)
{
	int ret;

	/* 0x03: Number of address bits for row. */
	contents[0x03] = sim_log2(512*2*1024*1024) / 2;
	/* 0x04: Number of address bits for column. */
	contents[0x04] = sim_log2(512*2*1024*1024)
			- sim_log2(512*2*1024*1024) / 2;
	/* 0x11: SDRAM Device Attributes, Number of Banks on 
	 *       SDRAM Device*/
	contents[0x11] = 2;
	
	ret = write(1, contents, sizeof(contents));
	assert(ret == sizeof(contents));

	return 0;
}
