#!/bin/sh -e

# autogen.sh - script to bootstrap the distribution rolling engine

# This script is free software; you can distribute it and/or modify it
# under the terms of the GNU GPL.  See the file COPYING.

# Usage:
#
#  sh ./autogen.sh && ./configure && make distcheck
#
# If you want to force an update of the VERSION, run a
#
#  touch NEWS
#
# before the sh ./bootstrap .
#
# If you don't want an auto-generated version number, do something like
#
#  echo 'm4_define([ST_VERSION], [20041015-cvs.9])' > VERSION.m4 ; touch NEWS; touch ChangeLog; touch VERSION.m4; touch stamp.*; make distcheck
#
#
# Both methods yield a tarball which one can install doing
#
# $ tar zxf PACKAGENAME-*.tar.gz
# $ cd PACKAGENAME-*
# $ ./configure
# $ make
# # make install

# requirements:
#  GNU autoconf, from e.g. ftp.gnu.org:/pub/gnu/autoconf/
#  GNU automake, from e.g. ftp.cygnus.com:/pub/tromey

set -x

# hack as used in pcproxy
test -f acinclude.m4 || {
    if test -f /usr/share/autoconf-archive/ac_define_dir.m4
    then
        ln -s /usr/share/autoconf-archive/ac_define_dir.m4 acinclude.m4
    else
        cat <<EOT
You need the autoconf-archive Debian package, version >= 20031029-1.
Alternatively, you could please install the GNU Autoconf Macro Archive's
http://www.gnu.org/software/ac-archive/htmldoc/ac_define_dir.html as
acinclude.m4.
EOT
   fi
}

# Debian automake package installs as automake-version.  Use this
# to make sure the right automake is being used.
aclocal-1.9
autoheader
automake-1.9 --add-missing --gnu
autoconf

# alternatively, run
#  autoreconf --install --symlink

set +x
echo "You can now run \"./configure\""
