/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM Region Manager
 * File: evms2/engine/plugins/lvm/lvm_groups.h
 */

/* Functions exported from lvm_groups.c. */
extern lvm_volume_group_t * lvm_allocate_volume_group(vg_disk_t * vg,
						      char * vg_name,
						      storage_container_t * disk_group);
extern void lvm_deallocate_volume_group(lvm_volume_group_t * group);
extern int lvm_find_group_for_pv(storage_object_t * segment,
				 pv_disk_t * pv,
				 lvm_volume_group_t ** group);
extern int lvm_add_pv_to_group_list(lvm_physical_volume_t * pv_entry,
				    lvm_volume_group_t * group);
extern int lvm_add_new_pv_to_group(lvm_physical_volume_t * pv_entry,
				   lvm_volume_group_t * group);
extern int lvm_remove_pv_from_group(lvm_physical_volume_t * pv_entry);
extern int lvm_check_vg_name(char * name);
extern int lvm_check_pe_size(u_int32_t * pe_size);
extern vg_disk_t * lvm_initialize_new_vg(u_int32_t pe_size);
extern int lvm_check_segment_for_group(storage_object_t * segment,
				       lvm_volume_group_t * group);
extern int lvm_check_segment_for_group_inclusion(storage_object_t * segment,
						 lvm_volume_group_t * group);
extern int lvm_transfer_segment_to_group(storage_object_t * segment,
					 lvm_volume_group_t * group);
extern void lvm_fix_group_after_pv_removal(lvm_volume_group_t * group);
extern int lvm_can_add_object(storage_object_t * object,
			      storage_container_t * container);
extern int lvm_can_remove_object(storage_object_t * object);
extern int lvm_can_shrink_pv(lvm_physical_volume_t *pv_entry,
			     u_int64_t *shrink_limit);
extern int lvm_expand_pv_in_container(storage_container_t *container,
				      storage_object_t *consumed_object,
				      storage_object_t *expand_object,
				      list_anchor_t input_objects,
				      option_array_t *options);
extern int lvm_shrink_pv_in_container(storage_container_t *container,
				      storage_object_t *consumed_object,
				      storage_object_t *shrink_object,
				      list_anchor_t input_objects,
				      option_array_t *options);

