# $Id: evms-cvs.spec,v 1.7 2002/03/28 21:48:10 kcorry Exp $

%define use_kgcc	0
%define use_efence	0

%{?_with_kgcc: %{expand: %%define use_kgcc 1}}
%{?_without_kgcc: %{expand: %%define use_kgcc 0}}

%{?_with_efence: %{expand: %%define use_efence 1}}
%{?_without_efence: %{expand: %%define use_efence 0}}

%if %{use_kgcc}
%define ccompiler	kgcc
%else
%define ccompiler	gcc
%endif

%if %{use_efence}
%define efence_config_params	"--with-efence"
%else
%define efence_config_params	"--without-efence"
%endif

Name:		evms
Version:	cvs%(date +"%Y%m%d")
Release:	1
Summary:	EVMS user-space tools.
Group:		System Environment/Base
License:	GPL
Packager:	corryk@us.ibm.com
URL:		http://www.sourceforge.net/projects/evms

Buildrequires:	cvs gtk+-devel autoconf glib-devel
%if %{use_efence}
Buildrequires:	ElectricFence
%endif

BuildRoot:	%{_tmppath}/%{name}-%{version}-root

%description
This package contains the user-space tools needed to manage EVMS (Enterprise
Volume Management System) volumes.

In order to use these user-space tools, you must also have your kernel patched
with the most recent EVMS code. This code is available in the source package
on the project web page http://www.sf.net/projects/evms/.

Please see the EVMS-HOWTO on the project web page or in the source package
for detailed instructions on patching your kernel with EVMS and using the
tools after installation.

%package md
Summary: Experimental multiple device ('md') plugin.
Group: System Environment/Base
Requires: %{name} = %{version}
%if %{use_efence}
Requires: ElectricFence
%endif

%description md
This package contains an experimental evms plugin that offers
compatability with the standard Linux 'md' software RAID driver.

%package lvm
Summary: EVMS command-line compatability with Linux LVM tools.
Group: System Environment/Base
Requires: %{name} = %{version}
%if %{use_efence}
Requires: ElectricFence
%endif

%description lvm
The evms-lvm package provides command-line software that emulates the 
behavior of the traditional Linux LVM tools.

%package gui
Summary: Graphic configuration for EVMS.
Group: System Environment/Base
Requires: %{name} = %{version} gtk+ glib
Buildrequires: gtk+-devel glib-devel
%if %{use_efence}
Requires: ElectricFence
%endif

%description gui
A graphic tool for configuring EVMS services.

%package devel
Summary: EVMS development libraries and header files.
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
The evms-devel package contains C libraries and header files necessary
for building EVMS-aware applications.

%prep
export CVSPASS=$RPM_SOURCE_DIR/evms-cvs-password

if [ ! -d "$CVSPASS" ]; then
	cat > $CVSPASS <<EOF
:pserver:anonymous@cvs.evms.sourceforge.net:/cvsroot/evms A
EOF
fi

if [ -d EVMS/engine/CVS ]; then
	(cd EVMS/engine && cvs -z3 update -dP)
else
	export CVSROOT=`cat $CVSPASS | awk '{print $1}'`
	mkdir -p EVMS/engine
	(cd EVMS && cvs -z3 co engine)
fi

if [ -d EVMS/linux/CVS ]; then
	(cd EVMS/linux && cvs -z3 update -dP)
else
	export CVSROOT=`cat $CVSPASS | awk '{print $1}'`
	mkdir -p EVMS/linux
	(cd EVMS && cvs -z3 co linux)
fi

%setup -T -D -n EVMS/engine

%build
if [ -x /usr/bin/getconf ] ; then
	NRPROC=$(/usr/bin/getconf _NPROCESSORS_ONLN)
	if [ $NRPROC -eq 0 ] ; then
		NRPROC=1
	fi
else
	NRPROC=1
fi

rm -f config.cache
autoconf
CC=%{ccompiler} \
	%configure \
	--with-kernel=$RPM_BUILD_DIR/EVMS/linux \
	--with-plugins=all \
	--with-interfaces=all \
	%{efence_config_params}
make -j$NRPROC clean
make -j$NRPROC

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%makeinstall
rm -f $RPM_BUILD_ROOT%{_libdir}/libevms.so
ln -s libevms-1.0.0.so $RPM_BUILD_ROOT%{_libdir}/libevms.so

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
/usr/sbin/evms
/usr/sbin/evmsn
/usr/sbin/evms_devnode_fixup
/usr/sbin/evms_info_level
/usr/sbin/evms_rediscover

/usr/lib/libdlist-1.0.so
/usr/lib/libevms-1.0.0.so

/usr/lib/evms/libaixregmgr-0.1.0.so
/usr/lib/evms/libbbr-1.0.0.so
/usr/lib/evms/libdefsegmgr-1.0.0.so
/usr/lib/evms/libdrivelink-1.0.0.so
/usr/lib/evms/liblocaldskmgr-1.0.0.so
/usr/lib/evms/liblvmregmgr-1.0.0.so
/usr/lib/evms/libos2regmgr-1.0.0.so
/usr/lib/evms/libsnapshot-2.0.0.so

/usr/man/man8/evms.8.gz

%files md
/usr/lib/evms/libmdregmgr-0.1.0.so

%files lvm
%defattr(-,root,root)
/usr/sbin/evms_vgscan
/usr/sbin/evms_pvscan
/usr/sbin/evms_lvscan
/usr/sbin/evms_vgdisplay
/usr/sbin/evms_pvdisplay
/usr/sbin/evms_lvdisplay
/usr/sbin/evms_vgcreate
/usr/sbin/evms_lvcreate
/usr/sbin/evms_vgremove
/usr/sbin/evms_lvremove
/usr/sbin/evms_vgextend
/usr/sbin/evms_lvextend
/usr/sbin/evms_vgreduce
/usr/sbin/evms_lvreduce

%files gui
%defattr(-,root,root)
/usr/sbin/evmsgui

%files devel
%defattr(-,root,root)
/usr/include/evms/appAPI.h
/usr/include/evms/appstructs.h
/usr/include/evms/common.h
/usr/include/evms/enginestructs.h
/usr/include/evms/frontend.h
/usr/include/evms/fullengine.h
/usr/include/evms/options.h
/usr/include/evms/plugfuncs.h
/usr/include/evms/plugin.h

%changelog
* Thu Mar 28 2002 Kevin Corry <corryk@us.ibm.com>
- Updated all necessary version numbers for 1.0.0 release.

* Mon Mar 4 2002 Kevin Corry <corryk@us.ibm.com>
- Updated all necessary version numbers for 0.9.2 release.

* Thu Feb 14 2002 Kevin Corry <corryk@us.ibm.com>
- Added evms_info_level utility.
- Updated all necessary version numbers for 0.9.1 release.

* Mon Jan 14 2002 Kevin Corry <corryk@us.ibm.com>
- Added evms_rediscover utility.
- Updated all necessary version numbers for 0.9.0 release.

* Thu Dec 13 2001 Kevin Corry <corryk@us.ibm.com>
- Added ncurses and text-mode user interfaces to the main package.
- Updated all necessary version numbers for 0.2.4 release.

* Mon Dec 3 2001 Lars Kellogg-Stedman <lars@larsshack.org>
- fetch linux repository for header files

* Thu Nov 30 2001 Lars Kellogg-Stedman <lars@larsshack.org>
- created spec file.

