/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: print_size.c
 */ 

#ifndef _LVM_HELP_PRINT_SIZE_
#define _LVM_HELP_PRINT_SIZE_

/* Function: print_size
 *
 *	This function is based on code from the lvm_show_size function in the
 *	LVM tools library, from Heinz Mauelshagen and Sistina Software
 *	(www.sistina.com).
 *
 *	Apparently size is now expressed in sectors instead
 *	of kilobytes. Will have to verify this when testing.
 *
 *	After calling this function, the caller is responsible for freeing
 *	the memory for the returned string.
 */
char * print_size( unsigned long long size, int long_format )
{
	int s,sz;
	unsigned long byte = 1024 * 1024 * 1024;	// 1 GB
	char *size_buf = NULL;
	static char size_char[] = "TGMK";
	static char *size_string[] = {	"Tera",
					"Giga",
					"Mega",
					"Kilo"  };

	size /= 2;

	if ( ! (size_buf = malloc(128)) ) {
		printf("%s -- Memory Allocation Error.\n", cmd);
		return NULL;
	}
	memset(size_buf, 0, 128);

	for ( s = 0; size_char[s] != 0; s++ ) {
		if ( size >= byte) {
			sz = sprintf(size_buf, "%.2f", ((float)size)/byte);
			while ( size_buf[sz-1] == '0')
				sz--;
			if ( size_buf[sz-1] == '.')
				sz--;
			if ( long_format )
				sz += sprintf( &size_buf[sz], " %sbyte%c", size_string[s], 0);
			else
				sz += sprintf( &size_buf[sz], " %cB%c", size_char[s], 0);
			break;
		}
		byte /= 1024;
	}

	if ( strlen(size_buf) == 0 ) {
		strcpy(size_buf, "0");
	}
	return size_buf;
}

#endif

