/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: helpsys.c
 */

/*
 * Change History:
 *
 * 10/2001  B. Rafanello  Initial version.
 *
 */

/*
 *
 */

/* Identify this file. */
#define HELPSYS_C


/*--------------------------------------------------
 * Necessary include files
 --------------------------------------------------*/

#include <stdio.h>
#include <sys/types.h>
#include "helpsys.h"
#include "screener.h"

/*--------------------------------------------------
 * Private constants
 --------------------------------------------------*/
 
 
/*--------------------------------------------------
 * Private types
 --------------------------------------------------*/


/*--------------------------------------------------
 * Private variables
 --------------------------------------------------*/


/*--------------------------------------------------
 * Private Function Prototypes
 --------------------------------------------------*/
static void Do_Allocate_Help(void);
static void Do_Assign_Help(void);
static void Do_Create_Help(void);
static void Do_Delete_Help(void);
static void Do_Expand_Help(void);
static void Do_Probe_Help(void);
static void Do_Query_Help(void);
static void Do_Remove_Help(void);
static void Do_Rename_Help(void);
static void Do_Revert_Help(void);
static void Do_Shrink_Help(void);
static void Do_Default_Help(void);
static void Do_Set_Help(void);
static void Do_Check_Help(void);
static void Do_Defrag_Help(void);
static void Do_Format_Help(void);
static void Do_Unformat_Help(void);

       
/*--------------------------------------------------
 * Public Functions Available
 --------------------------------------------------*/
void Display_Help(Executable_Node * Current_Node)
{
  if (Current_Node->NodeValue == AllocateStr )
  {
    Do_Allocate_Help();
  }
  else if ( Current_Node->NodeValue == AssignStr )
  {
    Do_Assign_Help();
  }
  else if ( Current_Node->NodeValue == CreateStr )
  {
    Do_Create_Help();
  }
  else if ( Current_Node->NodeValue == DeleteStr )
  {
    Do_Delete_Help();
  }
  else if ( Current_Node->NodeValue == ExpandStr )
  {
    Do_Expand_Help();
  }
  else if ( Current_Node->NodeValue == ShrinkStr )
  {
    Do_Shrink_Help();
  }
  else if ( Current_Node->NodeValue == RemoveStr )
  {
    Do_Remove_Help();
  }
  else if ( Current_Node->NodeValue == RenameStr )
  {
    Do_Rename_Help();
  }
  else if ( Current_Node->NodeValue == RevertStr )
  {
    Do_Revert_Help();
  }
  else if ( Current_Node->NodeValue == ProbeStr )
  {
    Do_Probe_Help();
  }
  else if ( Current_Node->NodeValue == QueryStr )
  {
    Do_Query_Help();
  }
  else if ( Current_Node->NodeValue == SetStr)
  {
    Do_Set_Help();
  }
  else if ( Current_Node->NodeValue == CheckStr)
  {
    Do_Check_Help();
  }
  else if ( Current_Node->NodeValue == DefragmentStr)
  {
    Do_Defrag_Help();
  }
  else if ( Current_Node->NodeValue == FormatStr)
  {
    Do_Format_Help();
  }
  else if ( Current_Node->NodeValue == UnformatStr)
  {
    Do_Unformat_Help();
  }
  else
  {
    Do_Default_Help();
  }

  return;
}


/*--------------------------------------------------
 * Private Functions Available
 --------------------------------------------------*/
static void Do_Allocate_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Allocate Command\n");
  printf("\n");
  printf("\n");

  printf("The Allocate command is used to allocate regions or segments from\n");
  printf("blocks of freespace.  It has the following form:\n");
  printf("\n");
  printf("Allocate : <freespace> , <name> = <value>\n");
  printf("\n");
  printf("where <freespace> is the name of a region or segment which represents\n");
  printf("             freespace (ex. sdb_freespace1)\n");
  printf("      <name> is the name of an option accepted by the Region Manager or\n");
  printf("             Segment Manager which created <freespace>\n");
  printf("      <value> is an acceptable value for the option <name>\n");
  printf("\n");
  printf("Example:  Given a disk with no partitions, which is under the control of the\n");
  printf("          Default Segment Manager, create a 50 MB segment in an extended \n");
  printf("          partition.  The new segment does not have to be bootable.\n");
  printf("\n");
  printf("a:sdb_freespace1,size=50MB,offset=0,primary=false,bootable=false\n");
  printf("\n");
  printf("\n");
  return;
}

static void Do_Assign_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Assign Command\n");
  printf("\n");
  printf("\n");
  printf("The Assign command is used to assign a Segment Manager to any\n");
  printf("disk or segment in the system which does not already have a Segment\n");
  printf("Manager assigned to it.  The Assign command may be abbreviated to 'as'\n");
  printf("on the command line.\n");
  printf("\n");
  printf("The Assign command has the following form:\n");
  printf("\n");
  printf("Assign : <Segment Mgr Name> = { <name> = <value> , <name> = <value> ... } ,\n");
  printf("         <Disk Name>\n");
  printf("\n");
  printf("where <Segment Mgr Name> is the name of the Segment Manager that is to\n");
  printf("           be assigned to a disk.\n");
  printf("      <name> is the name of an option accepted by the Segment Manager.\n");
  printf("      <value> is an acceptable value for option <name>\n");
  printf("      <Disk Name> is the name of the disk which is to have the Segment\n");
  printf("           Manager assigned to it.\n");
  printf("\n");
  printf("\n");
  printf("Example:  You install a brand new disk into your computer.  You wish\n");
  printf("          to partition this disk into multiple partitions using the\n");
  printf("          Default Segment Manager.  What must you do before you can\n");
  printf("          partition the disk?\n");
  printf("\n");
  printf("You must assign the Default Segment Manager to the disk.  If EVMS \n");
  printf("identifies the disk as sdb, then the command to do this would be:\n");
  printf("\n");
  printf("as:DefaultSegMgr={TypeByName=Linux},sdb\n");
  printf("\n");
  printf("This command will cause the Default Segment Manager to assume control\n");
  printf("of the disk sdb, store My_Disk as the name of the disk, and prepare\n");
  printf("the disk for partitioning.  As a result of this, sdb_freespace1 will be\n");
  printf("created to represent the space available on sdb, and this space can be\n");
  printf("divided into segments(partitions) using the Allocate or Create commands.\n");
  printf("\n");
  printf("\n");
  return;
}

static void Do_Create_Help(void)
{
  printf("\n");
  printf("\n");
  printf("=====================================================================\n");
  printf("\n");
  printf("\n");
  printf("The Create Command\n");
  printf("\n");
  printf("\n");
  printf("The Create command is used to create volumes, storage objects,\n");
  printf("regions, segments, and containers.  It can be abbreviated as the\n");
  printf("letter c on the command line.  The different items that it can create\n");
  printf("can also be abbreviated as a single letter on the command line. \n");
  printf("\n");
  printf("The Create command has several forms:\n");
  printf("\n");
  printf("for creating containers:\n");
  printf("\n");
  printf("Create : Container , <Region Mgr Name> = { <name> = <value> , <name> = <value>\n");
  printf("         ... } , <Segment or Disk name> , <Segment or Disk name>, ...\n");
  printf("\n");
  printf("where <Region Mgr Name> is the name of the EVMS Region Manager to use \n");
  printf("           when creating the container\n");
  printf("      <name> is the name of an option accepted by the Region Manager\n");
  printf("      <value> is an acceptable value for option <name>\n");
  printf("      <Segment or Disk name> is the name of a segment or disk which is\n");
  printf("           to be used in the creation of the container.\n");
  printf("\n");
  printf("Example:  Given a system with three available hard drives (sdc, sdd, hdc),\n");
  printf("          use the EVMS LVM Region Manager to combine these disks into a\n");
  printf("          container called Sample Container with a PE size of 16KB.\n");
  printf("\n");
  printf("c:c,LvmRegMgr={name=\"Sample Container\",pe_size=16KB},sdc,sdd,hdc\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("for creating storage objects:\n");
  printf("\n");
  printf("Create : Object , <Feature Name> = { <name> = <value> , <name> = <value> ...}\n");
  printf("         , <Backing Store> , <Backing Store> ...\n");
  printf("\n");
  printf("where <Feature Name> is the name of the EVMS Feature to use when \n");
  printf("           creating the storage object\n");
  printf("      <name> is the name of an option accepted by the Feature\n");
  printf("      <value> is an acceptable value for option <name>\n");
  printf("      <Backing Store> is the name of a region, segment, disk, or storage\n");
  printf("           object to be used in the creation of the new storage object\n");
  printf("\n");
  printf("Example:  Given a system with a volume /dev/evms/Source, and an available\n");
  printf("          segment sdb5, create a snapshot object called My Snapshot Object\n");
  printf("          using the EVMS Snapshot feature.  /dev/evms/Source is the source\n");
  printf("          of the snapshot, and sdb5 is the backing store for the snapshot.\n");
  printf("\n");
  printf("c:o,Snapshot={original=/dev/evms/Source,snapshot=\"My Snapshot Object\",\n");
  printf("     writeable=false},sdb5\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("for creating regions:\n");
  printf("\n");
  printf("Create : Region , <Region Mgr Name> = { <name> = <value> , <name> = <value> ...}\n");
  printf("         , <Backing Store> , <Backing Store> ...\n");
  printf("\n");
  printf("where <Region Mgr Name> is the name of the EVMS Region Manager to use.\n");
  printf("      <name> is the name of an option accepted by the Region Manager.\n");
  printf("      <value> is an acceptable value for option <name>.\n");
  printf("      <Backing Store> is the name of a region, segment, or disk to be\n");
  printf("           used in the creation of the new region\n");
  printf("\n");
#ifdef OS2_REGION_MANAGER_AVAILABLE
  printf("Example:  Given a system with three available segments, hda5, hdb9, hdc2,\n");
  printf("          combine these segments into a single region using the OS2 Region\n");
  printf("          Manager.\n");
  printf("\n");
  printf("The OS/2 Region Manager has not been implemented yet.\n");
  printf("\n");
#endif  
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("for creating segments:\n");
  printf("\n");
  printf("Create: Segment , <Freespace Segment> , <name> = <value> , <name> = <value> ...\n");
  printf("\n");
  printf("where <Freespace Segment> is the name of a segment representing freespace\n");
  printf("      <name> is the name of an option accepted by the Segment Manager that\n");
  printf("           created <Freespace Segment>\n");
  printf("      <value> is an acceptable value for option <name>\n");
  printf("\n");
  printf("Example:  Given a disk which is under the control of the Default Segment\n");
  printf("          Manager, and which has no primary partitions, and which has a \n");
  printf("          200 MB freespace segment called sdb_freespace1, create a 50 MB \n");
  printf("          logical segment.  The new segment does not have to be bootable.\n");
  printf("\n");
  printf("c:s,sdb_freespace1,size=50MB,offset=0,primary=false,bootable=false\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("for creating compatibility volumes:\n");
  printf("\n");
  printf("Create : Volume , <Segment or Region> , Compatibility\n");
  printf("\n");
  printf("where <Segment or Region> is the name of the segment or region which is to\n");
  printf("           become a volume.\n");
  printf("\n");
  printf("Example:  Given a system with an unused segment, sda3, turn this segment\n");
  printf("          into a compatibility volume.\n");
  printf("\n");
  printf("c:v,sda3,c\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("for creating EVMS volumes:\n");
  printf("\n");
  printf("Create : Volume , <Backing Store> , Name = <User Defined Name>\n");
  printf("\n");
  printf("where <Backing Store> is any segment, disk, region, or storage object\n");
  printf("           which is not already a volume, or a part of volume or storage\n");
  printf("           object\n");
  printf("      <User Defined Name> is the name that the user would like the volume\n");
  printf("           to have.  This name must be unique throughout the system, and \n");
  printf("           the volume, once created, will be known as \n");
  printf("           /dev/evms/<User Defined Name>\n");
  printf("\n");
  printf("Example:  Given a system with an unused segment sda3, make sda3 an EVMS \n");
  printf("          volume know as \"Widow Maker\".\n");
  printf("\n");
  printf("c:v,sda3,n=\"Widow Maker\"\n");
  printf("\n");
  printf("\n");
  printf("=====================================================================\n");
  printf("\n");
  printf("\n");
  return;
}

static void Do_Delete_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Delete Command\n");
  printf("\n");
  printf("\n");

  printf("The Delete command deletes a volume, storage object, region, or\n");
  printf("segment from the system.  The delete command may be abbreviated to \n");
  printf("the single letter 'd' on the command line.\n");
  printf("\n");
  printf("The Delete command has the following form:\n");
  printf("\n");
  printf("Delete : <Item Name>\n");
  printf("\n");
  printf("where <Item Name> is the name of the volume, object, region, or segment\n");
  printf("           that is to be deleted.\n");
  printf("\n");
  printf("Examples:  \n");
  printf("\n");
  printf("To delete an unmounted volume called /dev/evms/Fred, use:\n");
  printf("\n");
  printf("  d:/dev/evms/Fred\n");
  printf("\n");
  printf("To delete an unused segment called sdb7, use:\n");
  printf("\n");
  printf("  d:sdb7\n");
  printf("\n");
  printf("To delete an unused storage object called snap, use:\n");
  printf("\n");
  printf("  d:snap\n");
  printf("\n");
  printf("To delete an empty container (i.e. - it exports no regions) called\n     lvm/Kevins_Stuff, use:\n");
  printf("\n");
  printf("  d:lvm/Kevins_Stuff\n");
  printf("\n");
  printf("To delete an unused region called Temp, use:\n");
  printf("\n");
  printf("  d:Temp\n");
  printf("\n");
  printf("\n");
  return;
}

static void Do_Expand_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Expand Command\n");
  printf("\n");
  printf("\n");
  printf("The Expand Command is used to increase the size of a volume, storage object, or\n");
  printf("storage container.  \n");
  printf("\n");
  printf("\n");
  printf("To increase the size of a Storage Container:\n");
  printf("\n");
  printf("Storage Containers are expanded by adding segments or regions to them.\n");
  printf("When expanding containers, the Expand command has the following form:\n");
  printf("\n");
  printf("Expand : <Container Name> , < Storage To Use > ... , < Storage To Use > \n");
  printf("\n");
  printf("where Expand may be abbreviated as the single letter E\n");
  printf("      < Container Name> is the name of the container to expand\n");
  printf("      < Storage To Use > is the name of a segment or region to add\n");
  printf("           to the container specified by < Container Name >\n");
  printf("\n");
  printf("\n");
  printf("To increase the size of a Volume or Storage Object:\n");
  printf("\n");
  printf("An EVMS volume or storage object may be comprised of one or more storage\n");
  printf("objects, regions, segments, or disks.  Whether or not a volume or storage\n");
  printf("object can be expanded depends upon how it is constructed.  For example, if\n");
  printf("a volume consists of a single segment with no EVMS features applied to it, \n");
  printf("then whether or not it can be expanded depends upon whether or not the segment\n");
  printf("manager which created that segment can increase the size of that segment.  A\n");
  printf("more complicated volume may have several ways to expand. For example, a volume\n");
  printf("created from several segments using EVMS Drive Linking may be expanded by\n");
  printf("increasing the size of one of the segments being linked to form the volume, or\n");
  printf("by using EVMS Drive Linking to add another segment to the volume, or both.\n");
  printf("In this case, we say that the volume has multiple expansion points, because\n");
  printf("there are multiple ways in which the volume can be expanded.  EVMS allows the\n");
  printf("user complete control over how a volume is expanded.  This means that, to \n");
  printf("expand a volume, the user must specify which expansion point is to be used to\n");
  printf("expand the volume.  The same is true for storage objects.  Thus, in our last\n");
  printf("example, there were two expansion points.  One was the storage object created\n");
  printf("by EVMS Drive Linking.  This storage object could be expanded by adding another\n");
  printf("segment to it.  The second expansion point would be the last segment used in\n");
  printf("the storage object formed by EVMS Drive Linking.  (While the other segments used\n");
  printf("to create this storage object may be capable of being expanded, EVMS Drive \n");
  printf("Linking prohibits them from expanding as it is not set up to handle that case.)\n");
  printf("\n");
  printf("To find the expansion points for a storage object or volume, the Query Expand\n");
  printf("Points command should be used.  Once the expansion points for a volume or \n");
  printf("storage object are known, they can be used with this command to expand the\n");
  printf("volume or stoage object.\n");
  printf("\n");
  printf("The Expand command has the following form:\n");
  printf("\n");
  printf("Expand : <Expansion Point> , <Name> = <Value> , ... , <Name> = <Value> , \n");
  printf("         <Storage to use> , ... , <Storage to use> \n");
  printf("\n");
  printf("where <Expansion Point> is the name of an expansion point as provided by the\n");
  printf("                        Query Expand Points command\n");
  printf("      <Name> is the name of an option supported by the plug-in module that\n");
  printf("             controls <Expansion Point>\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("      <Storage to use> is the name of an acceptable storage object, region,\n");
  printf("          segment, freespace, or disk to use for expanding the volume.\n");
  printf("\n");
  printf("Example:  Given a volume created from three segments using EVMS Drive Linking.\n");
  printf("          The three segments used are sda1, sdb1, and sdc1.  The storage object\n");
  printf("          created by EVMS Drive Linking is called DL1, and the volume is called\n");
  printf("          /dev/evms/Sample_Volume.  The segment sdc1 is controlled by the \n");
  printf("          Default Segment Manager (DefaultSegMgr), and has a 50 MB block of \n");
  printf("          freespace (sdc_freespace1) adjacent to it on disk.  Also, there is\n");
  printf("          an unused 200MB segment known as hda7 available in the system.  The\n");
  printf("          Query Expand Points command indicates that this volume has two\n");
  printf("          expansion points: DL1 and sdc1.  Expand this volume by 250MB.\n");
  printf("\n");
  printf("First, we must consider the order in which we will use the expand points to\n");
  printf("expand the volume.  Currently, sdc1 is an expand point.  Since EVMS Drive\n");
  printf("Linking allows only the last segment it is linking to be expanded, sdc1 must\n");
  printf("be the last segment that EVMS Drive Linking is using to create DL1.  If we \n");
  printf("add hda7 to DL1, then hda7 will become the last segment used in DL1, and sdc1\n");
  printf("will not be an expansion point anymore.  Without being able to expand sdc1,\n");
  printf("will not be able to reach our goal of expanding the volume by 250MB.  However,\n");
  printf("expanding sdc1 has no affect on our ability to add hda7 to DL1, so if we expand\n");
  printf("sdc1 before we add hda7 to DL1, we will be able to achieve our goal of expanding\n");
  printf("the volume by 250MB.  This will require two commands to accomplish.  First, to\n");
  printf("expand sdc1, we use:\n");
  printf("\n");
  printf("e:sdc1,size=50MB,sdc_freespace1\n");
  printf("\n");
  printf("Now, to add hda7 to DL1, use the command:\n");
  printf("\n");
  printf("e:DL1,hda7\n");
  printf("\n");
  printf("Now the volume will be 250MB larger than before.\n");
  printf("\n");
  printf("\n");

  return;
}

static void Do_Probe_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Probe Command\n");
  printf("\n");
  printf("\n");

  printf("The Probe command is used to probe the system for hardware changes.\n");
  printf("This is useful when the media in a removeable media device has been changed.\n");
  printf("The Probe command will commit any pending changes (from prior commands) \n");
  printf("to disk before probing the system for hardware changes, even if the -c\n");
  printf("option was used when invoking the EVMS Command Line Interpreter.\n");
  printf("The Probe command may be abbreviated as a single letter 'P' in commands.\n");
  printf("\n\n");
  return;
}

static void Do_Query_Help(void)
{
  printf("\n");
  printf("\n");
  printf("=====================================================================\n");
  printf("\n");
  printf("\n");
  printf("The Query Command\n");
  printf("\n");
  printf("\n");
  printf("The Query command is used to obtain information about the state of EVMS and\n");
  printf("the volumes, storage objects, regions, containers, segments, and disks in the\n");
  printf("system.  The Query command has several different forms.  One is used for\n");
  printf("gathering information about the volumes, storage objects, regions, containers,\n");
  printf("segments, disks, and plug-in modules in the system.  The other forms of the \n");
  printf("Query command are used for gathering information related to various tasks that\n");
  printf("may be performed by the user on items in the system.\n");
  printf("\n");
  printf("\n");
  printf("For gathering information about Volumes, Storage Objects, Regions, Containers,\n");
  printf("Segments, Disks, or Plug-in Modules, use this form of the Query command:\n");
  printf("\n");
  printf("Query : <Type of data to return> , <filter> , ... , <filter>\n");
  printf("\n");
  printf("where <Type of data to return> is either:\n");
  printf("                       Plugins         (abbreviated as P)\n");
  printf("                       Volumes         (abbreviated as V)\n");
  printf("                       Regions         (abbreviated as R)\n");
  printf("                       Objects         (abbreviated as O)\n");
  printf("                       Containers      (abbreviated as C)\n");
  printf("                       Disks           (abbreviated as D)\n");
  printf("                       Segments        (abbreviated as S)\n");
  printf("      <filter> is one of the available filters for the type of data being\n");
  printf("           returned.  A filter retstricts what is returned based upon \n");
  printf("           some characteristic of the items being returned.  The available\n");
  printf("           filters for a query depend upon <Type of data to return>.\n");
  printf("\n");
  printf("When processing a query of this type, the Command Line Interpreter first\n");
  printf("gathers all items in the system of <Type of data to return>, puts them into\n");
  printf("a list, called the Return Values List, and then lets each of the filters\n");
  printf("specified by the user examine the Return Values List and remove any items\n");
  printf("they do not like.  Once all of the filters have processed the Return Values\n");
  printf("List, the Command Line Interpreter will display whatever items remain in the\n");
  printf("Return Values List.\n");
  printf("\n");
  printf("A note about filters:  Not all filters will work with every query.  Furthermore,\n");
  printf("some filters may be mutually exclusive.  See the EVMS Command Line Grammer to\n");
  printf("determine which combinations of filters are allowed for a particular query.\n");
  printf("\n");
  printf("The EVMS Command Line Interpeter supports the following filters:\n");
  printf("\n");
  printf("\n");
  printf("---------- Plug-in Type Filter ----------\n");
  printf("\n");
  printf("This filter is only available when <Type of data to return> is equal to Plugins.\n");
  printf("This filter removes from the Return Values List any entries for plug-in modules \n");
  printf("which are not of the type specified.  The form of this filter is:\n");
  printf("\n");
  printf("Type = <Plug-in Type>\n");
  printf("\n");
  printf("where Type may be abbreviated as a single letter T\n");
  printf("      <Plug-in Type> is one of:\n");
  printf("                     Device Manager              (abbreviated as D)\n");
  printf("                     Feature                     (abbreviated as F)\n");
  printf("                     Region Manager              (abbreviated as R)\n");
  printf("                     Segment Manager             (abbreviated as S)\n");
  printf("                     Filesystem Interface Module (abbreviated as FSIM)\n");
  printf("                     Distributed Lock Management (abbreviated as DLM)\n");
  printf("                     Cluster Management          (abbreviated as CM)\n");
  printf("\n");
  printf("\n");
  printf("---------- Plug-in Filter ----------\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is either Plugins,\n");
  printf("Volumes, Objects, Containers, Disks, or Segments.  This filter removes from the\n");
  printf("Return Values List any entries which represent items that have no association\n");
  printf("with the specified plug-in module.  For Volumes, this means that any volume\n");
  printf("which was created without the use of the specified plug-in module will be \n");
  printf("removed from the Return Values List.  The same is true for Storage Objects.\n");
  printf("For Regions, if the region does not come from a container created by the \n");
  printf("specified plug-in module, it will be removed from the Return Values List.\n");
  printf("For Containers, any container not created by the specified plug-in module\n");
  printf("will be removed from the Return Values List.  For Segments, any Segment not\n");
  printf("created by the specified plug-in module will be removed from the Return Values\n");
  printf("List.  For Disks, any disk not claimed by the specified plug-in module will be\n");
  printf("removed from the Return Values List.  Finally, for plug-in modules, this filter\n");
  printf("will remove all plug-in modules other than the one specified from the Return\n");
  printf("Values List.  The form of this filter is:\n");
  printf("\n");
  printf("Plugin = <Plug-in Module Identifier>\n");
  printf("\n");
  printf("where Plugin may be abbreviated as a single letter P\n");
  printf("      <Plug-in Module Identifer> is the name or ID number of a plug-in module\n");
  printf("\n");
  printf("\n");
  printf("---------- Volume Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is either Plugins, \n");
  printf("Regions, or Objects.  This filter removes from the Return Values List any\n");
  printf("item that was not used in the construction of the specified volume.  The\n");
  printf("form of this filter is:\n");
  printf("\n");
  printf("Volume = <Volume Name>\n");
  printf("\n");
  printf("where Volume may be abbreviated as a single letter V\n");
  printf("      <Volume Name> is the fully qualified name of a volume\n");
  printf("\n");
  printf("\n");
  printf("---------- Object Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is either Plugins,\n");
  printf("Volumes, or Regions.  This filter removes from the Return Values List any \n");
  printf("item that either did not create the specified object, or which was created\n");
  printf("without using the specified storage object.  Thus, for plug-in modules, it\n");
  printf("will remove from the Return Values List all plug-in modules except for those\n");
  printf("that are needed to create the specified storage object.  For Volumes, it will\n");
  printf("remove from the Return Values List any volume that does not use the specified\n");
  printf("storage object.  For Regions, it removes from the Return Values List any region\n");
  printf("which was not used in the creation of the specified storage object.  The form of\n");
  printf("this filter is:\n");
  printf("\n");
  printf("Object = <Object Name>\n");
  printf("\n");
  printf("where Object may be abbreviated as a single letter O\n");
  printf("      <Object Name> is the name of an object that EVMS knows about\n");
  printf("\n");
  printf("\n");
  printf("---------- Container Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is either Plugins,\n");
  printf("Volumes, Regions, Objects or Segments.  This filter has the following behavior:\n");
  printf("\n");
  printf("When <Type of data to return> is Volumes, this filter removes from the\n");
  printf("Return Values List any volume which was constructed without using a region\n");
  printf("from the specified container.\n");
  printf("\n");
  printf("When <Type of data to return> is Regions, this filter removes from the\n");
  printf("Return Values List any regions which do not come from the specifed \n");
  printf("container.\n");
  printf("\n");
  printf("When <Type of data to return> is Objects, this filter removes from the\n");
  printf("Return Values List any object which was contructed without using a region\n");
  printf("from the specified container.\n");
  printf("\n");
  printf("When <Type of data to return> is Segments, this filter removes from the\n");
  printf("Return Values List any segment which is was not used to create the container.\n");
  printf("\n");
  printf("When <Type of data to return> is Plugins, this filter removes from the\n");
  printf("Return Values List all plugins which were not used to create the container.\n");
  printf("\n");
  printf("\n");
  printf("The form of this filter is:\n");
  printf("\n");
  printf("Container = <Container Name>\n");
  printf("\n");
  printf("where Container may be abbreviated as a single letter C\n");
  printf("      <Container Name> is the name of a container that EVMS knows about\n");
  printf("\n");
  printf("\n");
  printf("---------- Region Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is either Volumes,\n");
  printf("Objects, Regions, or Containers.  This filter has the following behavior:\n");
  printf("\n");
  printf("When <Type of data to return> is Volumes, this filter removes from the\n");
  printf("Return Values List any volume which was constructed without using the\n");
  printf("specified region.\n");
  printf("\n");
  printf("When <Type of data to return> is Objects, this filter removes from the\n");
  printf("Return Values List any object which was contructed without using the\n");
  printf("specified region.\n");
  printf("\n");
  printf("When <Type of data to return> is Containers, this filter removes from the\n");
  printf("Return Values List any container other than the one from which it came.\n");
  printf("\n");
  printf("\n");
  printf("The form of this filter is:\n");
  printf("\n");
  printf("Region = <Region Name>\n");
  printf("\n");
  printf("where Region may be abbreviated as a single letter R\n");
  printf("      <Region Name> is the name of a region that EVMS knows about\n");
  printf("\n");
  printf("\n");
  printf("---------- Disk Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("This filter is available when <Type of data to return> is Segments.\n");
  printf("This filter removes from the Return Values List any segment which\n");
  printf("does not lie on the specified disk.\n");
  printf("\n");
  printf("The form of this filter is:\n");
  printf("\n");
  printf("Disk = <Disk Name>\n");
  printf("\n");
  printf("where Disk may be abbreviated as a single letter D\n");
  printf("      <Disk Name> is the name of a disk that EVMS knows about\n");
  printf("\n");
  printf("\n");
  printf("---------- Size Filters ----------\n");
  printf("\n");
  printf("\n");
  printf("There are three size filters: Less Than, Greater Than, and Equal To.  These\n");
  printf("filters are available when <Type of data to return> is either Volumes, Regions,\n");
  printf("Containers, Objects, Disks, or Segments.  These filters remove items from the\n");
  printf("Return Values List based upon their size.\n");
  printf("\n");
  printf("The Less Than filter has the following form:\n");
  printf("\n");
  printf("LT <XXX> <Unit>\n");
  printf("\n");
  printf("where <XXX> is a positive integer or 0\n");
  printf("      <Unit> is either KB, MB, GB, or TB\n");
  printf("\n");
  printf("\n");
  printf("The Greater Than filter has the following form:\n");
  printf("\n");
  printf("GT <XXX> <Unit>\n");
  printf("\n");
  printf("where <XXX> is a positive integer or 0\n");
  printf("      <Unit> is either KB, MB, GB, or TB\n");
  printf("\n");
  printf("\n");
  printf("The Equal filter has the following form:\n");
  printf("\n");
  printf("EQ <XXX> <Unit> , <Precision> <\n");
  printf("\n");
  printf("where <XXX> is a positive integer or O\n");
  printf("      <Unit> if specified, must be either KB, MB, GB, or TB.\n");
  printf("      <Precision> is a positive integer.  It indicates how 'sloppy' a match to\n");
  printf("         make.  If no unit is specified, then Precision is interpreted to be a\n");
  printf("         percentage, in which case a value is considered to be equal to <XXX> if\n");
  printf("         it is within <XXX> plus or minus <Precision> percent of <XXX>.  If a\n");
  printf("         unit (KB, MB, GB, TB) is specified for <Precision>, then a value is\n");
  printf("         is considered equal to <XXX> if it is within the range of \n");
  printf("         <XXX> - <Precision> to <XXX> + <Precision>.\n");
  printf("\n");
  printf("\n");
  printf("---------- Freespace Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("The Freespace filter removes from the Return Values List any items which do\n");
  printf("not contain freespace.  This filter is only useable when <Type of data to \n");
  printf("return> is Containers.  The form of the Freespace filter is:\n");
  printf("\n");
  printf("Freespace , <Size Filters>\n");
  printf("\n");
  printf("where Freespace may be abbreviated as the single letter F\n");
  printf("      <Size Filters> are the same Size Filters as above, only now, instead of\n");
  printf("           using the size of the containers for comparisons, the <Size Filters>\n");
  printf("           will use the freespace in the containers for comparisons.\n");
  printf("\n");
  printf("\n");
  printf("---------- Expandable Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("The Expandable filter is available when <Type of data to return> is either \n");
  printf("Volumes, Regions, Objects, or Segments.  This filter removes from the Return\n");
  printf("Values List any items which can not be expanded.  The form of this filter is:\n");
  printf("\n");
  printf("Expandable\n");
  printf("\n");
  printf("where Expandable may be abbreviated as the single letter E\n");
  printf("\n");
  printf("\n");
  printf("---------- Shrinkable Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("The Shrinkable filter is available when <Type of data to return> is either \n");
  printf("Volumes, Regions, Objects, or Segments.  This filter removes from the Return\n");
  printf("Values List any items which can not be shrunk.  The form of this filter is:\n");
  printf("\n");
  printf("Shrinkable\n");
  printf("\n");
  printf("where Shrinkable may be abbreviated as the single letter S\n");
  printf("\n");
  printf("\n");
  printf("---------- Unclaimed Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("The Unclaimed filter is available when <Type of data to return> is Disks.  It\n");
  printf("removes from the Return Values List all disks which have been claimed by a\n");
  printf("Partition Manager plug-in module (which means that those disks have a \n");
  printf("recognized partitioning scheme in place).  Thus, the disks left in the Return\n");
  printf("Values List will either have no partitioning scheme on them, or their \n");
  printf("partitioning scheme is unrecognized.  The form of this filter is:\n");
  printf("\n");
  printf("Unclaimed\n");
  printf("\n");
  printf("where Unclaimed can be abbreviated as a single letter U\n");
  printf("\n");
  printf("\n");
  printf("---------- List Options Pseudo Filter ----------\n");
  printf("\n");
  printf("\n");
  printf("List Options is treated like a filter, but what it actually does is cause the\n");
  printf("EVMS Command Line Interpreter to list what can be done with each item in the \n");
  printf("Return Values List.  The form of this filter is:\n");
  printf("\n");
  printf("List Options\n");
  printf("\n");
  printf("where List Options may be abbreviated as LO\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("Sample Queries using Filters:\n");
  printf("\n");
  printf("To query the plug-ins in the system and their options:\n");
  printf("\n");
  printf("q:p,lo\n");
  printf("\n");
  printf("\n");
  printf("To query only the Region Manager plug-ins in the system and their options:\n");
  printf("\n");
  printf("q:p,t=r,lo\n");
  printf("\n");
  printf("\n");
  printf("To query the volumes in the system:\n");
  printf("\n");
  printf("q:v\n");
  printf("\n");
  printf("\n");
  printf("To query the volumes in the system over 1GB in size:\n");
  printf("\n");
  printf("q:v,gt 1GB\n");
  printf("\n");
  printf("\n");
  printf("To query the storage objects in the system:\n");
  printf("\n");
  printf("q:o\n");
  printf("\n");
  printf("\n");
  printf("To query the segments in the system that reside on disk sda:\n");
  printf("\n");
  printf("q:s,d=sda\n");
  printf("\n");
  printf("\n");
  printf("To query the segments in the system that belong to the container lvm/MyStuff,\n");
  printf("which are over 500MB in size yet less than 2 GB in size, and which come from\n");
  printf("disk sda:\n");
  printf("\n");
  printf("q:s,c=lvm/MyStuff,GT 500MB,lt 2GB,d=sda\n");
  printf("\n");
  printf("\n");
  printf("---------------------------------------------------------------------\n");
  printf("\n");
  printf("\n");
  printf("Specialty Query Commands\n");
  printf("\n");
  printf("\n");
  printf("********** Query Children **********\n");
  printf("\n");
  printf("\n");
  printf("This command returns the items that were used to create the specified item.\n");
  printf("For example, the children of a storage object are the storage objects, regions,\n");
  printf("disks, or segments that were used to create the specified storage object.\n");
  printf("The form of this command is:\n");
  printf("\n");
  printf("Query : Children , <Item Name>\n");
  printf("\n");
  printf("where Children may be abbreviated as CHI\n");
  printf("      <Item Name> is the name of a Volume, Storage Object, Region, Segment,\n");
  printf("           or Container.\n");
  printf("\n");
  printf("\n");
  printf("********** Query Parent **********\n");
  printf("\n");
  printf("\n");
  printf("This command returns the item (if any) that uses the specified item.  For\n");
  printf("example, if a storage object is specified, then this will return the volume or\n");
  printf("storage object which was created using the specified storage object, if such \n");
  printf("a volume or storage object exists.  The form of this command is:\n");
  printf("\n");
  printf("Query : Parent , <Item Name>\n");
  printf("\n");
  printf("where Parent may be abbreviated as Par\n");
  printf("      <Item Name> is the name of a Storage Object, Region, Segment, Container,\n");
  printf("           or Disk.\n");
  printf("\n");
  printf("\n");
  printf("********** Query Expand Points **********\n");
  printf("\n");
  printf("\n");
  printf("This query returns the expansion points for a volume or storage object.  The\n");
  printf("expansion points for a volume or storage object are those entities within the \n");
  printf("volume or storage object which can be expanded without causing a loss of data.\n");
  printf("The form of this command is:\n");
  printf("\n");
  printf("Query : Expand Points , <Item Name>\n");
  printf("\n");
  printf("where Expand Points may be abbreviated as EP\n");
  printf("      <Item Name> is the name of a Storage Object or Volume.\n");
  printf("\n");
  printf("\n");
  printf("********** Query Shrink Points **********\n");
  printf("\n");
  printf("\n");
  printf("This query returns the shrink points for a volume or storage object.  The\n");
  printf("shrink points for a volume or storage object are those entities within the \n");
  printf("volume or storage object which can be shrunk without causing a loss of data.\n");
  printf("The form of this command is:\n");
  printf("\n");
  printf("Query : Shrink Points , <Item Name>\n");
  printf("\n");
  printf("where Shrink Points may be abbreviated as SP\n");
  printf("      <Item Name> is the name of a Storage Object or Volume.\n");
  printf("\n");
  printf("\n");
  printf("********** Query Extended Info **********\n");
  printf("\n");
  printf("\n");
  printf("This command allows access to any additional information that may be available\n");
  printf("for a plug-in module, a storage object, a disk, a region, a segment, or a \n");
  printf("container.  The form of this command is:\n");
  printf("\n");
  printf("Query : Extended Info , <Item Name> , <Field Name>\n");
  printf("\n");
  printf("where Extended Info may be abbreviated as EI\n");
  printf("      <Item Name> is the name of a storage object, disk, region, segment, \n");
  printf("           container, or plug-in module, or it can be the numeric ID of a\n");
  printf("           plug-in module.\n");
  printf("      <Field Name> is the name of a specific piece of extended information.\n");
  printf("           Extended Information is grouped into fields.  Each field has a name\n");
  printf("           and one or more values associated with it. <Field Name> is optional.\n");
  printf("\n");
  printf("\n");
  printf("********** Query Acceptable **********\n");
  printf("\n");
  printf("\n");
  printf("The purpose of this query is to allow the user to find out which storage\n");
  printf("objects, regions, segments, or disks are acceptable for creating or expanding a\n");
  printf("volume, storage object, region, or segment.  The command works as follows:\n");
  printf("\n");
  printf("For use when creating containers, objects, or regions, the user will specify the\n");
  printf("plug-in module being used, the values for the options that the plug-in is to use\n");
  printf("when creating the container/object/region, and then the storage objects,\n");
  printf("regions, segments, or disks that the user has already decided to use.  The query\n");
  printf("will return any storage objects, regions, segments, or disks which are still\n");
  printf("available and which are still acceptable for use in creating the\n");
  printf("container/object/region.  An example of using this command would be to determine\n");
  printf("what segments should be used to create a software RAID 5 storage object.\n");
  printf("Initially no segments have been selected, so all unused segments in the system\n");
  printf("may be available and may be returned by this query.  Next, the user chooses an\n");
  printf("initial segment, and, as a result of that choice, all segments on the same drive\n");
  printf("are not acceptable anymore.  To find out what segments are still available to be\n");
  printf("chosen, the user may use this query again, only now they specify the segments\n");
  printf("that they have already chosen, and this query will return all of the segments\n");
  printf("that may still be chosen.  The user will now choose another segment, and then\n");
  printf("use this query again, specifying all of the segments they have already chosen\n");
  printf("in the order in which they chose them, to see which segments are still available\n");
  printf("to be selected.  This iterative process may be used to build an ordered list of\n");
  printf("segments that may then be used in an actual create command to create the desired\n");
  printf("software RAID 5 storage object.  \n");
  printf("\n");
  printf("For use when expanding volumes or storage objects, the user will specify the \n");
  printf("volume or storage object to be expanded along with any storage objects, segments,\n");
  printf("regions, or disks that have already been chosen to be used in the expansion, and\n");
  printf("this query will return the storage objects, regions, segments, or disks which\n");
  printf("may still be selected and used to expand the specified volume or storage object\n");
  printf("Again, as described above, an interative process may be used to build an ordered\n");
  printf("list of the storage objects, regions, segments, or disks that can be used to\n");
  printf("expand the specified volume or storage object with an actual expand command.\n");
  printf("\n");
  printf("The query has two forms.  For determining what is acceptable for use with a Create\n");
  printf("command use the following form:\n");
  printf("\n");
  printf("Query : Acceptable , Create , <Item To Create> , <Plug-in Module> = { <name> = \n");
  printf("     < value > ... , <name> = <value> } , <item to use> ... , <item to use>\n");
  printf("\n");
  printf("where Acceptable may be abbreviated by the single letter A\n");
  printf("      Create may be abbreviated by the single letter C\n");
  printf("      <Item To Create> is either Object, Region, or Container.  Object may be\n");
  printf("           abbreviated as a single letter O, Region may be abbreviated as a\n");
  printf("           single letter R, and Container may be abbreviated as a single \n");
  printf("           letter C.\n");
  printf("      <Plug-in Module> is the name or ID number of the plug-in module to use\n");
  printf("           when creating <Item To Create>.\n");
  printf("      <name> is the name of an option supported by <Plug-in Module>\n");
  printf("      <value> is a legitimate value for the option <name>\n");
  printf("      <item to use> is the EVMS name of a storage object, region, segment or\n");
  printf("           disk which is to be used to create <Item To Create>.\n");
  printf("\n");
  printf("\n");
  printf("For determining what is acceptable for use with an Expand Command, use the\n");
  printf("following form:\n");
  printf("\n");
  printf("Query : Acceptable , Expand , <Item to Expand> , <item to use> ... <item to use>\n");
  printf("\n");
  printf("where Acceptable may be abbreviated by the single letter A\n");
  printf("      Expand may be abbreviated by the single letter E\n");
  printf("      <Item to Expand> is the name of a Volume or Storage Object that is to \n");
  printf("           be expanded\n");
  printf("      <item to use> is the EVMS name of a storage object, region, segment or\n");
  printf("           disk which is to be used when expanding <Item To Expand>.\n");
  printf("\n");
  printf("\n");
  printf("\n");
  printf("=====================================================================\n");
  printf("\n");
  printf("\n");
  return;
}

static void Do_Remove_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Remove Command\n");
  printf("\n");
  printf("\n");
  printf("The remove command is used to remove a segment manager from a disk.  A\n");
  printf("segment manager may only be removed from a disk when all of the data segments\n");
  printf("on that disk have been deleted.  The remove command actually causes a segment\n");
  printf("manager to remove its metadata from the disk, thereby leaving an empty disk\n");
  printf("which may be used directly, or to which another segment manager may be assigned.\n");
  printf("\n");
  printf("Example:  You have developed a new disk partitioning scheme and have created an\n");
  printf("          EVMS Segment Manager plug-in called MyScheme to test it.  You have a\n");
  printf("          disk, known as sdb, which you wish to use to test your new\n");
  printf("          partitioning scheme, but the disk is under the control of the Default\n");
  printf("          Segment Manager.  Remove the Default Segment Manager from the disk so\n");
  printf("          that you can use the disk to test your new partitioning scheme.\n");
  printf("\n");
  printf("After deleting all of the data partitions on the test disk, use the command:\n");
  printf("\n");
  printf("Rem:sdb\n");
  printf("\n");
  printf("\n");

  return;
}

static void Do_Rename_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Rename Command\n");
  printf("\n");
  printf("\n");
  printf("The Rename Command is used to change the name of an EVMS volume.\n");
  printf("\n");
  printf("The Rename Command has the following form:\n");
  printf("\n");
  printf("Rename : <Volume Name> , Name = <New Volume Name>\n");
  printf("\n");
  printf("where <Volume Name> is the name of the volume whose name is to be changed,\n");
  printf("      <New Volume Name> is the new name for the volume.  Please note that\n");
  printf("         the new volume name must be in single quotes if it contains spaces\n");
  printf("         or any non-alphanumeric characters.\n");
  printf("\n");
  printf("Note:  Both the Rename and Name keywords may be abbreviated as their first\n");
  printf("       letters, as seen in the example below.\n");
  printf("\n");
  printf("Example:  Rename the volume /dev/evms/John to /dev/evms/Fred.\n");
  printf("\n");
  printf(" r:/dev/evms/John,n=Fred\n");
  printf("\n");
  
  return;
}

static void Do_Revert_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Revert Command\n");
  printf("\n");
  printf("The Revert Command strips away the topmost layer of an EVMS volume or\n");
  printf("storage object, thereby restoring it to its previous EVMS state.  Thus,\n");
  printf("an EVMS Volume will revert to the EVMS Storage Object from which it came.\n");
  printf("\n");
  printf("The Revert Command has the following form:\n");
  printf("\n");
  printf("Revert : <Volume or Storage Object>\n");
  printf("\n");
  printf("where <Volume or Storage Object> is the name of the volume or storage object\n");
  printf("           to revert.\n");
  printf("\n");
  printf("Note:  The Revert keyword may be abbreviated as 'Rev' in commands.\n");
  printf("\n");
  printf("Example:  Lets say we just created a storage object named Fred from a \n");
  printf("          storage object named Barney.  Fred is a rather complicated storage\n");
  printf("          object that would take time to recreate.  However, after creating\n");
  printf("          Fred we find out that we applied the wrong feature to Barney to\n");
  printf("          create Fred.  How do we remove the feature that was applied to \n");
  printf("          Barney to create Fred without having to delete Fred and start \n");
  printf("          from scratch?\n");
  printf("\n");
  printf("Rev:Fred\n");
  printf("\n");
  printf("The Revert Command will strip away the top most feature on Fred, thereby\n");
  printf("undoing the creation of Fred, and leaving us with Barney.\n");
  printf("\n");
  printf("\n");
  
  return;
}

static void Do_Shrink_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Shrink Command\n");
  printf("\n");
  printf("The Shrink command is used to reduce the size of a volume, storage object, or\n");
  printf("storage container.\n");
  printf("\n");
  printf("\n");
  printf("To reduce the size of a Storage Container:\n");
  printf("\n");
  printf("Storage Containers are reduced in size by removing one or more of the \n");
  printf("segments or regions they contain.\n");
  printf("\n");
  printf("The Shrink command has the following form when used with Storage Containers: \n");
  printf("\n");
  printf("Shrink : < Container Name > , < Storage To Remove > ... < Storage To Remove >\n");
  printf("\n");
  printf("where Shrink may be abbreviated by the single letter S\n");
  printf("      < Container Name > is the name of the storage container to shrink\n");
  printf("      < Storage To Remove > is the name of a segment or region in the\n");
  printf("           storage container which is to be removed from the storage\n");
  printf("           container.\n");
  printf("\n");
  printf("\n");
  printf("To reduce the size of a Volume or Storage Object:\n");
  printf("\n");
  printf("An EVMS volume or storage object may be comprised of one or more storage\n");
  printf("objects, regions, segments, or disks.  Whether or not a volume or storage\n");
  printf("object can be shrunk depends upon how it is constructed.  For example, if\n");
  printf("a volume consists of a single segment with no EVMS features applied to it, \n");
  printf("then whether or not it can be shrunk depends upon whether or not the segment\n");
  printf("manager which created that segment can decrease the size of that segment.  A\n");
  printf("more complicated volume may have several ways to shrink. For example, a volume\n");
  printf("created from several segments using EVMS Drive Linking may be shrunk by\n");
  printf("decreasing the size of one of the segments being linked to form the volume, or\n");
  printf("by using EVMS Drive Linking to remove a segment from the volume, or both.\n");
  printf("In this case, we say that the volume has multiple shrink points, because\n");
  printf("there are multiple ways in which the volume can be shrunk.  EVMS allows the\n");
  printf("user complete control over how a volume is shrunk.  This means that, to \n");
  printf("shrink a volume, the user must specify which shrink point is to be used to\n");
  printf("shrink the volume.  The same is true for storage objects.  Thus, in our last\n");
  printf("example, there were two shrink points.  One was the storage object created\n");
  printf("by EVMS Drive Linking.  This storage object could be shrunk by removing a\n");
  printf("segment from it.  The second shrink point would be the last segment used in\n");
  printf("the storage object formed by EVMS Drive Linking.  (While the other segments used\n");
  printf("to create this storage object may be capable of being shrunk, EVMS Drive \n");
  printf("Linking prohibits them from shrinking as it is not set up to handle that case.)\n");
  printf("\n");
  printf("To find the shrink points for a storage object or volume, the Query Shrink\n");
  printf("Points command should be used.  Once the shrink points for a volume or \n");
  printf("storage object are known, they can be used with this command to shrink the\n");
  printf("volume or stoage object.\n");
  printf("\n");
  printf("The Shrink command has the following form:\n");
  printf("\n");
  printf("Shrink : <Shrink Point> , <Name> = <Value> , ... , <Name> = <Value> , \n");
  printf("         <Storage to remove> , ... , <Storage to remove> \n");
  printf("\n");
  printf("where <Shrink Point> is the name of a shrink point as provided by the\n");
  printf("                     Query Shrink Points command\n");
  printf("      <Name> is the name of an option supported by the plug-in module that\n");
  printf("             controls <Shrink Point>\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("      <Storage to remove> is the name of an acceptable storage object, region,\n");
  printf("          segment, or disk to be shrunk or removed from the volume.\n");
  printf("\n");
  printf("Example:  Given a volume created from three segments using EVMS Drive Linking.\n");
  printf("          The three segments used are sda1, sdb1, and sdc1.  The storage object\n");
  printf("          created by EVMS Drive Linking is called DL1, and the volume is called\n");
  printf("          /dev/evms/Sample_Volume.  The segment sdc1 is controlled by the \n");
  printf("          Default Segment Manager (DefaultSegMgr), and can be shrunk by 50 MB.\n");
  printf("          The Query Shrink Points command returns DL1 and sdc1 as the available\n");
  printf("          shrink points.  Shrink the volume by 50MB.\n");
  printf("\n");
  printf("s:sdc1,size=50MB, sdc1\n");
  printf("\n");
  printf("\n");  

  return;
}

static void Do_Set_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Set Command\n");
  printf("\n");
  printf("Some Storage Objects, Regions, Containers, Segments, or Disks may have options\n");
  printf("associated with them that can be changed.  If a Query command which returns\n");
  printf("Storage Objects, Regions, Containers, Segments, or Disks is executed using\n");
  printf("the List Options Pseudo Filter, then the changeable options for each item\n");
  printf("returned will be listed with that item.\n");
  printf("\n");
  printf("The Set Command has the following form:\n");
  printf("\n");
  printf("Set : <Object> , <Name> = <Value> , ... , <Name> = <Value>\n");
  printf("\n");
  printf("where <Object> is the name of a Storage Object, Region, Container, Segment or\n");
  printf("           Disk whose options are to be changed\n");
  printf("      <Name> is the name of an option that can be set for <Object>\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("\n");
  printf("Note:  The Set keyword can not be abbreviated.\n");
  printf("\n");

  return;
}

static void Do_Check_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Check Command\n");
  printf("\n");
  printf("The Check Command performs a consistency check on the filesystem contained\n");
  printf("within the specified volume.  This is the equivalent of the Linux fsck\n");
  printf("command and is included here for the convenience of the user.\n");
  printf("\n");
  printf("The Check Command has the following form:\n");
  printf("\n");
  printf("Check : <Volume> , <Name> = <Value> , ... , <Name> = <Value>\n");
  printf("\n");
  printf("where <Volume> is the name of the volume whose filesystem is to be checked\n");
  printf("      <Name> is the name of an option supported by the FSIM for the filesystem\n");
  printf("           found on the specified volume\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("\n");
  printf("Note:  The Check keyword may be abbreviated as Ch in commands.\n");
  printf("\n");

  return;
}

static void Do_Defrag_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Defragment Command\n");
  printf("\n");
  printf("The Defragment Command defragments the filesystem contained within\n");
  printf("the specified volume\n");
  printf("\n");
  printf("The Defragment Command has the following form:\n");
  printf("\n");
  printf("Defragment : <Volume> , <Name> = <Value> , ... , <Name> = <Value>\n");
  printf("\n");
  printf("where <Volume> is the name of the volume whose filesystem is to be defragmented\n");
  printf("      <Name> is the name of an option supported by the FSIM for the filesystem\n");
  printf("           found on the specified volume\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("\n");
  printf("Note:  The Defragment keyword may be abbreviated as De in commands.\n");
  printf("\n");

  return;
}

static void Do_Format_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Format Command\n");
  printf("\n");
  printf("The Format Command creates a filesystem on a volume.  This is the\n");
  printf("equivalent of the Linux mkfs command and is included here for the\n");
  printf("convenience of the user.\n");
  printf("\n");
  printf("The Format Command has the following form:\n");
  printf("\n");
  printf("Format : <FSIM> = { <Name> = <Value> , ... , <Name> = <Value> } , <Volume>\n");
  printf("\n");
  printf("where <FSIM> is the name of a Filesystem Interface Module recognized by EVMS.\n");
  printf("           The specified FSIM will be used to create the filesystem on the\n");
  printf("           volume specified by <Volume>.  Normally there will be one FSIM for\n");
  printf("           each filesystem.  Thus, specifying the FSIM is the same as specifying\n");
  printf("           the filesystem.  In those cases where one FSIM supports more than one\n");
  printf("           filesystem, then an option will be used to specify which filesystem\n");
  printf("           should be created.\n");
  printf("      <Name> is the name of an option supported by the FSIM for the filesystem\n");
  printf("           found on the specified volume\n");
  printf("      <Value> is an acceptable value for option <Name>\n");
  printf("      <Volume> is the name of the volume where the filesystem is to be created\n");
  printf("\n");
  printf("Note:  The Format keyword may be abbreviated as the single letter F in commands.\n");
  printf("\n");

  return;
}

static void Do_Unformat_Help(void)
{
  printf("\n");
  printf("\n");
  printf("The Unformat Command\n");
  printf("\n");
  printf("The Unformat Command destroys the filesystem contained within the \n");
  printf("specified volume.  This is typically done by overwriting the metadata\n");
  printf("for the filesystem with 0's.  All data on the volume is lost.\n");
  printf("\n");
  printf("The Unformat Command has the following form:\n");
  printf("\n");
  printf("Unformat : <Volume>\n");
  printf("\n");
  printf("where <Volume> is the name of the volume whose filesystem is to be destroyed\n");
  printf("\n");
  printf("Note: The Unformat keyword may be abbreviated as a single letter U in commands.\n");
  printf("\n");

  return;
}

static void Do_Default_Help(void)
{

  printf("\n");
  printf("\n");
  printf("The EVMS Commands\n");
  printf("\n");
  printf("The EVMS Command Line Interpreter supports the following commands:\n");
  printf("\n");
  printf("Create - creates volumes, storage objects, regions, segments and\n");
  printf("         containers.\n");
  printf("Allocate - allocates regions and segments from freespace.\n");
  printf("Assign - assignes a segment manager to a disk/segment.\n");
  printf("Check  - performs an fsck operation on a volume. \n");
  printf("Delete - deletes volumes, containers, regions, segments, and\n");
  printf("         storage objects.\n");
  printf("Defragment - defragments the filesystem on a volume. \n");
  printf("Expand - expands the size of volumes, containers, regions, \n");
  printf("         segments, and storage objects.\n");
  printf("Format - peforms an mkfs operation on a volume. \n");
  printf("Help   - provides help on a specific EVMS command.\n");
  printf("Probe  - causes EVMS to check the system for hardware changes.\n");
  printf("Query  - gathers information about the volumes, containers, storage\n");
  printf("         objects, regions, and segments in the system.\n");
  printf("Remove - removes the segment manager assigned to a disk/segment.\n");
  printf("Rename - changes the names of volumes.\n");
  printf("Revert - deconstructs a volume or storage object a layer at a time.\n");
  printf("Set    - Some of the options associated with a storage object,\n");
  printf("         region, container, disk or segment may be modified.  This\n");
  printf("         command is used to modify such options.\n");
  printf("Shrink - reduces the size of volumes, containers, regions,\n");
  printf("         segments, and storage objects.\n");
  printf("Unformat - removes a filesystem from a volume.  The contents\n");
  printf("         of the volume are lost.\n");
  printf("\n");
  printf("To obtain detailed help on an EVMS command, enter the following at the\n");
  printf("EVMS command prompt:\n");
  printf("\n");
  printf("Help: <command>\n");
  printf("\n");
  printf("where <command> is one of the aforementioned commands.\n");
  printf("\n");
  printf("Example: Get detailed help on the Create command.\n");
  printf("\n");
  printf("Help:Create\n");
  printf("\n\n");

  return;
}

