/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_uuid.h
 */ 

#ifndef _LVM_UUID_H_
#define _LVM_UUID_H_ 1

// Functions exported from lvm_uuid.c
extern int lvm_check_for_uuid( char * uuid );
extern int lvm_create_uuid( char * uuid );
extern char * lvm_print_uuid( char * uuid );
extern int lvm_clear_uuid_list_entry(	lvm_volume_group_t	* group,
					u_int32_t		pv_number );
extern int lvm_set_uuid_list_entry(	lvm_volume_group_t	* group,
					u_int32_t		pv_number,
					unsigned char		* uuid );
extern int lvm_verify_pv_uuid(	lvm_physical_volume_t	* pv_entry,
				lvm_volume_group_t	* group );

#endif

