/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_info.h
 */ 

#ifndef _LVM_INFO_H_
#define _LVM_INFO_H_ 1

// Functions exported from lvm_info.c
extern int lvm_get_volume_info(	lvm_logical_volume_t	* volume,
				extended_info_array_t	** info_array );
extern int lvm_get_volume_extent_info(	lvm_logical_volume_t	* volume,
					extended_info_array_t	** info_array );
extern int lvm_get_group_info(	lvm_volume_group_t	* group,
				extended_info_array_t	** info_array );
extern int lvm_get_group_pv_list_info(	lvm_volume_group_t	* group,
					extended_info_array_t	** info_array );
extern int lvm_get_group_lv_list_info(	lvm_volume_group_t	* group,
					extended_info_array_t	** info_array );
extern int lvm_get_pv_info(	lvm_physical_volume_t	* pv_entry,
				extended_info_array_t	** info_array );
extern int lvm_get_pv_extent_info(	lvm_physical_volume_t	* pv_entry,
					extended_info_array_t	** info_array );

#endif

