/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: bsd.h
 *
 */

#ifndef BSD_HEADER
#define BSD_HEADER 1


// partition fs types
#define BSD_TAG_UNUSED   0x0000  // unused slice
#define BSD_TAG_SWAP     0x0001  // swap fs
#define BSD_TAG_VERS6    0x0002  // 6th version
#define BSD_TAG_VERS7    0x0003  // 7th version
#define BSD_TAG_SYSV     0x0004  // system 5
#define BSD_TAG_VERS7k   0x0005  // 7th version with 1k blocks
#define BSD_TAG_VERS8    0x0006  // 8th version
#define BSD_TAG_FASTBSD  0x0007  // fast bsd
#define BSD_TAG_MSDOS    0x0008  // msdos
#define BSD_TAG_LFSBSD   0x0009  // logging bsd
#define BSD_TAG_OTHER    0x000a  // unknown
#define BSD_TAG_HPFS     0x000b  // os2 hpfs
#define BSD_TAG_ISO9660  0x000c  // ISO
#define BSD_TAG_BOOT     0x000d  // boot code
#define BSD_TAG_AMIGA    0x000e  // amiga dos
#define BSD_TAG_MAC      0x000f  // mac hfs
#define BSD_TAG_ACORN    0x0010  // acorn file system
#define BSD_TAG_EXT2     0x0011  // ext2
#define BSD_TAG_NTFS     0x0012  // NT file system


#ifdef NEED_BSD_NAMES

#define BSD_TAG_NAME_COUNT 19
static const char *bsd_names[BSD_TAG_NAME_COUNT]={
     "UNUSED",
     "SWAP",
     "VERS 6",
     "VERS 7",
     "SYSTEM V",
     "VERS 7",
     "VERS 8",
     "BSD",
     "MSDOS",
     "LOGGING BSD",
     "UNKNOWN",
     "HPFS",
     "ISO9660",
     "BOOT",
     "AMIGA DOS",
     "MAC",
     "ACORN",
     "EXT2",
     "NTFS"
};

#endif


/*
 * BSD disklabel support by Yossi Gottlieb <yogo@math.tau.ac.il>
 * updated by Marc Espie <Marc.Espie@openbsd.org>
 */

/* check against BSD src/sys/sys/disklabel.h for consistency */

#define BSD_DISKMAGIC   (0x82564557UL)  /* The disk magic number */
#define BSD_MAXPARTITIONS   8
#define OPENBSD_MAXPARTITIONS   16
#define BSD_FS_UNUSED       0   /* disklabel unused partition entry ID */
struct bsd_disklabel {
    __u32   d_magic;        /* the magic number */
    __s16   d_type;         /* drive type */
    __s16   d_subtype;      /* controller/d_type specific */
    char    d_typename[16];     /* type name, e.g. "eagle" */
    char    d_packname[16];         /* pack identifier */
    __u32   d_secsize;      /* # of bytes per sector */
    __u32   d_nsectors;     /* # of data sectors per track */
    __u32   d_ntracks;      /* # of tracks per cylinder */
    __u32   d_ncylinders;       /* # of data cylinders per unit */
    __u32   d_secpercyl;        /* # of data sectors per cylinder */
    __u32   d_secperunit;       /* # of data sectors per unit */
    __u16   d_sparespertrack;   /* # of spare sectors per track */
    __u16   d_sparespercyl;     /* # of spare sectors per cylinder */
    __u32   d_acylinders;       /* # of alt. cylinders per unit */
    __u16   d_rpm;          /* rotational speed */
    __u16   d_interleave;       /* hardware sector interleave */
    __u16   d_trackskew;        /* sector 0 skew, per track */
    __u16   d_cylskew;      /* sector 0 skew, per cylinder */
    __u32   d_headswitch;       /* head switch time, usec */
    __u32   d_trkseek;      /* track-to-track seek, usec */
    __u32   d_flags;        /* generic flags */
#define NDDATA 5
    __u32   d_drivedata[NDDATA];    /* drive-type specific information */
#define NSPARE 5
    __u32   d_spare[NSPARE];    /* reserved for future use */
    __u32   d_magic2;       /* the magic number (again) */
    __u16   d_checksum;     /* xor of data incl. partitions */

            /* filesystem and partition information: */
    __u16   d_npartitions;      /* number of partitions in following */
    __u32   d_bbsize;       /* size of boot area at sn0, bytes */
    __u32   d_sbsize;       /* max size of fs superblock, bytes */
    struct  bsd_partition {     /* the partition table */
        __u32   p_size;     /* number of sectors in partition */
        __u32   p_offset;   /* starting sector */
        __u32   p_fsize;    /* filesystem basic fragment size */
        __u8    p_fstype;   /* filesystem type, see below */
        __u8    p_frag;     /* filesystem fragments per block */
        __u16   p_cpg;      /* filesystem cylinders per group */
    } d_partitions[BSD_MAXPARTITIONS];  /* actually may be more */
};


#define BSD_DISKLABEL_PART_TABLE_SECTOR_OFFSET 1

int do_bsd_partition_discover( LOGICALDISK *ld, Partition_Record *part );
int do_bsd_partition_commit( LOGICALDISK *ld, DISKSEG *seg );

#endif


