/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: volume.h
 *
 */

/*
 * Global functions exported by volume.c
 */

/* External APIs provided by volume.c */

extern int evms_can_create_volume(object_handle_t object);

extern int evms_can_create_compatibility_volume(object_handle_t object);

extern int evms_can_set_volume_name(object_handle_t volume);

extern int evms_create_volume(object_handle_t object,
                              char          * name);

extern int evms_set_volume_name(object_handle_t volume,
                                char          * name);

extern int evms_create_compatibility_volume(object_handle_t object);

extern int evms_can_mkfs(object_handle_t volume,
                         plugin_handle_t fsim);

extern int evms_can_unmkfs(object_handle_t volume);

extern int evms_can_fsck(object_handle_t volume);

extern int evms_can_defrag(object_handle_t volume);

extern int evms_mkfs(object_handle_t  volume,
                     plugin_handle_t  fsim,
                     option_array_t * options);

extern int evms_unmkfs(object_handle_t volume);

extern int evms_fsck(object_handle_t  volume,
                     option_array_t * options);

extern int evms_defrag(object_handle_t  volume,
                       option_array_t * options);

extern int evms_get_volume_list(object_handle_t    fsim,
                                handle_array_t * * volume_list);

/* Internal functions to share with other Engine source modules */

extern BOOLEAN is_volume_mounted(logical_volume_t * volume);

extern int get_evms_minor_number(uint * minor);

extern int get_compatibility_minor_number(uint * minor);

extern void free_option_array(option_array_t * options);
