/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: option.h
 *
 */

/*
 * Global functions exported by option.c
 */

/* External APIs provided by option.c */


extern int evms_get_option_count(task_handle_t handle,
								 int         * count);

extern int evms_get_option_descriptor(task_handle_t           handle,
									  u_int32_t               option,
									  option_descriptor_t * * descriptor);

extern int evms_get_option_value(task_handle_t handle,
								 u_int32_t     option,
								 value_t     * value);

extern int evms_set_option_value(task_handle_t handle,
								 u_int32_t     option,
								 value_t     * value,
								 u_int32_t   * info);

extern int evms_auto_select_option_value(task_handle_t handle,
										 u_int32_t     option,
										 value_t     * value,
										 u_int32_t    *info);

extern int evms_get_option_descriptor_by_name(task_handle_t           handle,
											  const char            * option,
											  option_descriptor_t * * descriptor);

extern int evms_get_option_value_by_name(task_handle_t handle,
										 const char  * option,
										 value_t     * value);

extern int evms_set_option_value_by_name(task_handle_t handle,
										 const char  * option,
										 value_t     * value,
										 u_int32_t   *info);

extern int evms_auto_select_option_value_by_name(task_handle_t handle,
												 const char  * option,
												 value_t     * value,
												 u_int32_t   * info);

/* Internal functions to share with other Engine source modules */

extern void free_option_descriptor_contents(void * object);
