/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: discover.h
 *
 */

/*
 * Global data exported by discover.c
 */

extern BOOLEAN discover_in_progress;

/*
 * Global functions exported by discover.c
 */

extern BOOLEAN remove_corrupt_object(ADDRESS   object,
                                     TAG       object_tag,
                                     uint      object_size,
                                     ADDRESS   object_handle,
                                     ADDRESS   parameters,
                                     BOOLEAN * free_memory,
                                     uint    * error);

extern int do_discovery(void);

extern int set_volume_in_object(ADDRESS object,
                                TAG     object_tag,
                                uint    object_size,
                                ADDRESS object_handle,
                                ADDRESS parameters);

extern void find_fsim_for_volume(logical_volume_t * volume);

extern int insert_new_volume_into_volume_list(logical_volume_t * new_volume);

extern int make_volume(storage_object_t * object,
                       char             * name,
                       u_int32_t          minor,
                       u_int32_t          flags,
                       u_int64_t          serial);

extern TAG get_tag_for_object(storage_object_t * object);

extern int sync_volume_minors_with_kernel(void);

extern void feature_header_disk_to_cpu(evms_feature_header_t * fh);
