%define name eris
%define version 1.2.1
%define release 1
%define libsuffix -1.2

Summary: A WorldForge client library.
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: System Environment/Libraries
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
Requires: Atlas-C++ >= 0.4.93 wfmath >= 0.3.2 skstream > 0.3
BuildRequires: Atlas-C++-devel >= 0.4.93 wfmath-devel >= 0.3.2 skstream-devel > 0.3 libsigc++-devel libstdc++-devel

%description
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%package devel
Summary: A WorldForge client library headers and static libs.
Group: Development/Libraries
Requires: %{name} = %{version} Atlas-C++-devel wfmath-devel skstream-devel libsigc++-devel libstdc++-devel

%description devel
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%package poll-glib
Summary: Headers to poll eris connections using glibs poll code.
Group: Development/Libraries
Requires: glib2

%description poll-glib
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks. These headers allow code handling network connections for Eris
to be integrated into glib in a glib or gtk+ based application.

%prep
%setup

%build
CXXFLAGS=$RPM_OPT_FLAGS %configure --enable-static
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_libdir}/lib*.so.*
%doc AUTHORS COPYING NEWS README

%files devel
%defattr(-,root,root)
%{_libdir}/lib*.so
%{_libdir}/lib*.la
%{_libdir}/lib*.a
%{_libdir}/pkgconfig/eris%{libsuffix}.pc
%{_includedir}/Eris%{libsuffix}/Eris/ArgumentDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/atlas_utils.h
%{_includedir}/Eris%{libsuffix}/Eris/Avatar.h
%{_includedir}/Eris%{libsuffix}/Eris/BaseConnection.h
%{_includedir}/Eris%{libsuffix}/Eris/ClassDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Connection.h
%{_includedir}/Eris%{libsuffix}/Eris/DebugDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Dispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/EncapDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Entity.h
%{_includedir}/Eris%{libsuffix}/Eris/Exceptions.h
%{_includedir}/Eris%{libsuffix}/Eris/Factory.h
%{_includedir}/Eris%{libsuffix}/Eris/IdDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Lobby.h
%{_includedir}/Eris%{libsuffix}/Eris/Log.h
%{_includedir}/Eris%{libsuffix}/Eris/Metaserver.h
%{_includedir}/Eris%{libsuffix}/Eris/OpDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Person.h
%{_includedir}/Eris%{libsuffix}/Eris/Player.h
%{_includedir}/Eris%{libsuffix}/Eris/PollDefault.h
%{_includedir}/Eris%{libsuffix}/Eris/Poll.h
%{_includedir}/Eris%{libsuffix}/Eris/Property.h
%{_includedir}/Eris%{libsuffix}/Eris/Room.h
%{_includedir}/Eris%{libsuffix}/Eris/ServerInfo.h
%{_includedir}/Eris%{libsuffix}/Eris/SignalDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/Timeout.h
%{_includedir}/Eris%{libsuffix}/Eris/Timestamp.h
%{_includedir}/Eris%{libsuffix}/Eris/TypeDispatcher.h
%{_includedir}/Eris%{libsuffix}/Eris/typeService.h
%{_includedir}/Eris%{libsuffix}/Eris/TypeInfo.h
%{_includedir}/Eris%{libsuffix}/Eris/Types.h
%{_includedir}/Eris%{libsuffix}/Eris/Utils.h
%{_includedir}/Eris%{libsuffix}/Eris/Wait.h
%{_includedir}/Eris%{libsuffix}/Eris/World.h

%files poll-glib
%defattr(-,root,root)
%{_libdir}/pkgconfig/eris-poll-glib%{libsuffix}.pc
%{_includedir}/Eris%{libsuffix}/Eris/PollGlibFD.h
%{_includedir}/Eris%{libsuffix}/Eris/PollGlib.h
%{_includedir}/Eris%{libsuffix}/Eris/PollGlibSource.h
%{_includedir}/Eris%{libsuffix}/Eris/PollGlibVersion.h
