# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Python configuration page.
"""

from ConfigurationPageBase import ConfigurationPageBase
from Ui_PythonPage import Ui_PythonPage

import Preferences

class PythonPage(ConfigurationPageBase, Ui_PythonPage):
    """
    Class implementing the Python configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("PythonPage")
        
        # set initial values
        index = self.stringEncodingComboBox.findText(\
            Preferences.getSystem("StringEncoding"))
        self.stringEncodingComboBox.setCurrentIndex(index)
        index = self.ioEncodingComboBox.findText(\
            Preferences.getSystem("IOEncoding"))
        self.ioEncodingComboBox.setCurrentIndex(index)
        
    def save(self):
        """
        Public slot to save the Python configuration.
        """
        Preferences.setSystem("StringEncoding",
            unicode(self.stringEncodingComboBox.currentText()))
        Preferences.setSystem("IOEncoding",
            unicode(self.ioEncodingComboBox.currentText()))
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = PythonPage()
    return page
