# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the logout data for CVS.
"""

from qt import *

from LogoutForm import cvsLogoutForm
from Config import ConfigCvsProtocols

class CvsLogoutDialog(cvsLogoutForm):
    """
    Class implementing a dialog to enter the logout data for CVS.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        cvsLogoutForm.__init__(self, parent, None, 1)
        
        self.validator = QIntValidator(self)
        self.portEdit.setValidator(self.validator)
        
        self.protocolComboBox.insertStringList(ConfigCvsProtocols)
        
        dummy = self.trUtf8('dummy')
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 5 strings (protocol, username, 
            remote hostname, remote port and repository).
        """
        return (unicode(self.protocolComboBox.currentText()),
            unicode(self.usernameEdit.text()),
            unicode(self.hostEdit.text()),
            unicode(self.portEdit.text()),
            unicode(self.repositoryEdit.text())
        )
