/*
 *  Copyright © 2011 Igalia S.L.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef EPHY_SQLITE_CONNECTION_H
#define EPHY_SQLITE_CONNECTION_H

#include <glib-object.h>
#include "ephy-sqlite-statement.h"

#include <sqlite3.h>

G_BEGIN_DECLS

#define EPHY_TYPE_SQLITE_CONNECTION (ephy_sqlite_connection_get_type ())

G_DECLARE_FINAL_TYPE (EphySQLiteConnection, ephy_sqlite_connection, EPHY, SQLITE_CONNECTION, GObject)

typedef enum {
  EPHY_SQLITE_CONNECTION_MODE_READ_ONLY,
  EPHY_SQLITE_CONNECTION_MODE_READWRITE
} EphySQLiteConnectionMode;

EphySQLiteConnection *  ephy_sqlite_connection_new                     (EphySQLiteConnectionMode mode);

gboolean                ephy_sqlite_connection_open                    (EphySQLiteConnection *self, const gchar *filename, GError **error);
void                    ephy_sqlite_connection_close                   (EphySQLiteConnection *self);

void                    ephy_sqlite_connection_get_error               (EphySQLiteConnection *self, GError **error);

gboolean                ephy_sqlite_connection_execute                 (EphySQLiteConnection *self, const char *sql, GError **error);
EphySQLiteStatement *   ephy_sqlite_connection_create_statement        (EphySQLiteConnection *self, const char *sql, GError **error);
gint64                  ephy_sqlite_connection_get_last_insert_id      (EphySQLiteConnection *self);

gboolean                ephy_sqlite_connection_begin_transaction       (EphySQLiteConnection *self, GError **error);
gboolean                ephy_sqlite_connection_rollback_transaction    (EphySQLiteConnection *self, GError **error);
gboolean                ephy_sqlite_connection_commit_transaction      (EphySQLiteConnection *self, GError **error);

gboolean                ephy_sqlite_connection_table_exists            (EphySQLiteConnection *self, const char *table_name);

GQuark                  ephy_sqlite_error_quark                        (void);

#define EPHY_SQLITE_ERROR ephy_sqlite_error_quark ()

G_END_DECLS

#endif /* EPHY_SQLITE_CONNECTION_H */

