
<object default-lang="javascript">
  <renderer name="blink-label"
   tag="blink-label">

    <attrib name="text"
     description="Set text of blinking label."
     value_desc="string"
     onset="blink_text_attrib_set"/>
    
    <attrib name="period"
     description="blink on/off period.  -1 to disable."
     value_desc="integer"
     onset="blink_period_attrib_set"/>

    <!-- This composite-implementation node will be copied as a child
         of the instantiated node each time.  This is then used to
         implement the blink-label. -->
    <composite-implementation>
      <timer interval="-1" action="blink_me" state="visible">
        <label text="blink!"/>
      </timer>
    </composite-implementation>

    <?javascript

function blink_period_attrib_set (renderer_node, node, attrib, value)
{
    timer = node.child ("timer");
    if (value == "") {
        value = "-1";
    } else if (value < 100) {
        value = 100;
    }
    timer.attrib.interval = value;
}

function blink_text_attrib_set (renderer_node, node, attrib, value)
{
    var label = node.child ("label");
    label.attrib.text = value;
}

function blink_me (timer)
{
    var label = timer.child ("label");
    if (timer.attrib.state == "visible") {
        label.attrib.visible = "false";
        timer.attrib.state = "invisible";
    } else {
        label.attrib.visible = "true";
        timer.attrib.state = "visible";
    }
}

    ?>

  </renderer>

  <renderer name="blink-tag"
   tag="blink-tag">

    <attrib name="period"
     description="blink on/off period.  -1 to disable."
     value_desc="integer"
     onset="blink_period_attrib_set"/>

    <!-- This composite-implementation node will be copied as a child
         of the instantiated node each time.  This is then used to
         implement the blink-label. -->
    <composite-implementation>
      <timer interval="-1" action="blink_me_m" state="visible"/>
    </composite-implementation>

    <?javascript


function blink_me_m (timer)
{
    var i;
    if (timer.attrib.state == "visible") {
	for (i in timer.parent().parent().children()) {
	    i.attrib.visible = "false";
	}
        timer.attrib.state = "invisible";
    } else {
	for (i in timer.parent().parent().children()) {
	    i.attrib.visible = "true";
	}
        timer.attrib.state = "visible";
    }
}

    ?>

  </renderer>
</object>

