#include <stdlib.h>
#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static gint
rendgtk_scrollwindow_policy_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *sw;
    GtkPolicyType xpolicy;
    GtkPolicyType ypolicy;
    
    sw = enode_get_kv (node, "top-widget");
    if (!sw)
	return TRUE;
    
    value = enode_attrib (node, "y-scrollbar-policy", NULL);
    if (ebuf_equal_str (value, "always")) {
	ypolicy = GTK_POLICY_ALWAYS;
    } else {
	ypolicy = GTK_POLICY_AUTOMATIC;
    }

    value = enode_attrib (node, "x-scrollbar-policy", NULL);
    if (ebuf_equal_str (value, "always")) {
	xpolicy = GTK_POLICY_ALWAYS;
    } else {
	xpolicy = GTK_POLICY_AUTOMATIC;
    }

    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    xpolicy, ypolicy);
    
    return TRUE;
}


static gint
rendgtk_scrollwindow_yscroll_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *sw;
    GtkAdjustment *y_adj;
    int page;
    float fval;

    sw = enode_get_kv (node, "top-widget");
    if (!sw)
	return TRUE;

    EDEBUG (("scrollwindow-renderer", "setting y-scroll"));
    y_adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (sw));
    page = y_adj->upper - y_adj->page_size;
    fval = atof (value->str);
    y_adj->value = page * fval / 100;
    EDEBUG (("scrollwindow-renderer", "page %i", page));
    gtk_adjustment_value_changed (y_adj);
    return TRUE;
}

static gint
rendgtk_scrollwindow_xscroll_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *sw;
    GtkAdjustment *x_adj;
    int page;
    float fval;

    sw = enode_get_kv (node, "top-widget");
    if (!sw)
	return FALSE;

    EDEBUG (("scrollwindow-renderer", "setting x-scroll"));
    x_adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (sw));
    page = x_adj->upper - x_adj->page_size;
    fval = atof (value->str);
    x_adj->value = page * fval / 100;
    EDEBUG (("scrollwindow-renderer", "page %i", page));
    gtk_adjustment_value_changed (x_adj);
    return TRUE;
}


static int
x_adj_changed (GtkAdjustment * adjustment, ENode * node)
{
    char val_str[15];
    float value;
    float scw;
    GtkWidget *sw;
    GtkAdjustment *x_adj;
    char *function;

    sw = enode_get_kv (node, "top-widget");
    if (!sw)
	return FALSE;

    x_adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (sw));

    scw = (x_adj->upper - x_adj->page_size);
    if (scw)
	value = (x_adj->value * 100) / scw;
    else
	value = 100;

    g_snprintf (val_str, 15, "%f", value);

    enode_attrib_quiet (node, "x-scroll", ebuf_new_with_str (val_str));

    function = enode_attrib_str (node, "onx-scrolled", NULL);
    enode_call_ignore_return (node, function, "");
    return FALSE;
}

static int
y_adj_changed (GtkAdjustment * adjustment, ENode * node)
{
    char val_str[32];
    float value;
    float scw;
    GtkWidget *sw;
    GtkAdjustment *y_adj;
    char *function;

    sw = enode_get_kv (node, "top-widget");
    if (!sw)
	return FALSE;

    y_adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (sw));

    scw = (y_adj->upper - y_adj->page_size);
    if (scw)
	value = (y_adj->value * 100) / scw;
    else
	value = 100;

    g_snprintf (val_str, sizeof (val_str), "%f", value);

    enode_attrib_quiet (node, "y-scroll", ebuf_new_with_str (val_str));

    function = enode_attrib_str (node, "ony-scrolled", NULL);
    enode_call_ignore_return (node, function, "");
    return FALSE;
}

static void
rendgtk_scrollwindow_render (ENode * node)
{
    GtkWidget *sw;
    GtkAdjustment *x_adj;
    GtkAdjustment *y_adj;

    sw = gtk_scrolled_window_new (NULL, NULL);


    x_adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (sw));
    y_adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (sw));

    enode_set_kv (node, "top-widget", sw);
    enode_set_kv (node, "bottom-widget", sw);

    gtk_signal_connect (GTK_OBJECT (y_adj), "value-changed",
			GTK_SIGNAL_FUNC (y_adj_changed), node);
    gtk_signal_connect (GTK_OBJECT (x_adj), "value-changed",
			GTK_SIGNAL_FUNC (x_adj_changed), node);

    /* default policy is automatic */
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    enode_attribs_sync (node);
    rendgtk_show_cond (node, sw);
}

static void
rendgtk_scrollwindow_parenter (ENode * parent_node, ENode * child_node)
{
    GtkWidget *sw;
    GtkWidget *child;


    sw = enode_get_kv (parent_node, "top-widget");
    if (!sw)
	return;

    child = enode_get_kv (child_node, "top-widget");
    if (!child)
	return;

    if (GTK_IS_TEXT (child)
#if 0
	|| GTK_IS_SHEET (child)
#endif				/* 0 Need to fix this. */
	|| GTK_IS_CTREE (child)) {
	gtk_container_add (GTK_CONTAINER (sw), child);
    } else {
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (sw), child);
    }
}

void
scrollwindow_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_scrollwindow_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_scrollwindow_parenter;
    element->tag = "scrollwindow";
    element->description = "Create a new scrollable window.";
    element_register (element);

    rendgtk_widget_attr_register (element, GTK_TYPE_SCROLLED_WINDOW);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "x-scroll";
    e_attr->description =
	"The percentage of the window that is scrolled in the horizontal direction";
    e_attr->value_desc = "percentage";
    e_attr->set_attr_func = rendgtk_scrollwindow_xscroll_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "y-scroll";
    e_attr->description =
	"The percentage of the window that is scrolled in the vertical direction";
    e_attr->value_desc = "percentage";
    e_attr->set_attr_func = rendgtk_scrollwindow_yscroll_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "y-scrollbar-policy";
    e_attr->description = "Specify if the vertical scrollbar should always be present.";
    e_attr->value_desc = "choice";
    e_attr->possible_values = "automatic,always";
    e_attr->set_attr_func = rendgtk_scrollwindow_policy_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "x-scrollbar-policy";
    e_attr->description = "Specify if the horizontal scrollbar should always be present.";
    e_attr->value_desc = "choice";
    e_attr->possible_values = "automatic,always";
    e_attr->set_attr_func = rendgtk_scrollwindow_policy_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onx-scroll";
    e_attr->description =
	"Function to call when the view is changed in the x direction";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(scrolled_window)";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "ony-scroll";
    e_attr->description =
	"Function to call when the view is changed in the y direction";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(scrolled_window)";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);
}


