<object name="mysinktest">

  <csink name="mysink" hostname="localhost" port="80" 
  		onconnect="myonconnect" ondisconnect="myondisconnect"
		onnewdata="myonnewdata" />

  <window ondelete="entity:exit" title="Sink Test" height="500" width="600">
    <halign>
      <valign expand="true"/>
      <label text="Hostname:"/>
      <entry name="remote-host" width="100" text="localhost" onenter="sethost"/>
      <button name="set-remote-host" label="Change" onclick="sethost"/>
      <label text="Port:"/>
      <entry name="remote-port" width="50" text="80" onenter="setport"/>
      <button name="set-remote-port" label="Change" onclick="setport"/>
      <valign expand="true"/>
    </halign>

    <halign>
      <valign expand="true"/>
      <button name="connect" label="CONNECT" onclick="myconnect"/>
      <button name="disconnect" label="DISCONNECT" onclick="mydisconnect" sensitive="false"/>
      <button name="ninja" label="Ninja Magic" onclick="ninjamagic">
        <?perl
	  sub ninjamagic
	  {
	    my $button = enode ("button.ninja");
	    my $xml = qq!
	      <include file="ninja-magic.e"/>
	      !;
	    my $node = enode ("window");
	    $node->append_xml ($xml);
	  }
	?>
      </button>
      <valign expand="true"/>
    </halign>
    
    <scrollwindow expand="true" name="scroller">
      <text name="textfield"/>
    </scrollwindow>

    <halign>
      <entry name="cursor" expand="true" onenter="writemesg"/>
      <button name="send" label="Send" onclick="writemesg" sensitive="false"/>
    </halign>


  </window>

  <perl> 
    <![CDATA[

      sub myonnewdata
      {
        my ($node, $mesg) = @_;
	my $text = enode ("text.textfield");
	my $scrollbar = enode ("scrollwindow.scroller");
	my $do_move = 0;

	if ($scrollbar->attrib ("y-scroll") >= 98)
	  {
	    $do_move = 1;
	  }
	
	$text->set_data ($text->get_data() . $mesg);
	
	if ($do_move)
	  {
	    $scrollbar->attrib ("y-scroll" => "100");
	  }
      }

      sub myonconnect
      {
        my $node = shift;
	my $connbutton = enode ("button.connect");
	my $discbutton = enode ("button.disconnect");
	my $sendbutton = enode ("button.send");
	my $scrollbar = enode ("scrollwindow.scroller");
	my $text = enode ("text.textfield");

	if ($scrollbar->attrib ("y-scroll") >= 98)
          {
            $do_move = 1;
          }

        $text->set_data ($text->get_data() . "Connected...\n");

        if ($do_move)
          {
            $scrollbar->attrib ("y-scroll" => "100");
          }

	$connbutton->attrib ("sensitive" => "false");
	$discbutton->attrib ("sensitive" => "true");
	$sendbutton->attrib ("sensitive" => "true");
      }

      sub myondisconnect
      {
        my $node = shift;
	my $connbutton = enode ("button.connect");
	my $discbutton = enode ("button.disconnect");
	my $sendbutton = enode ("button.send");
	my $scrollbar = enode ("scrollwindow.scroller");
	my $text = enode ("text.textfield");

	if ($scrollbar->attrib ("y-scroll") >= 98)
          {
            $do_move = 1;
          }

        $text->set_data ($text->get_data() . "Disconnected...\n");

        if ($do_move)
          {
            $scrollbar->attrib ("y-scroll" => "100");
          }

	$connbutton->attrib ("sensitive" => "true");
	$discbutton->attrib ("sensitive" => "false");
	$sendbutton->attrib ("sensitive" => "false");
      }

      sub myconnect
      {
        my $sink = enode ("csink.mysink");
    
        $sink->attrib ("action" => "connect");
      }

      sub mydisconnect
      {
        my $sink = enode ("csink.mysink");

	$sink->attrib ("action" => "disconnect");
      }

      sub writemesg
      {
        my $sink = enode ("csink.mysink");
	my $text = enode ("entry.cursor");
	my $mesg = $text->attrib ("text");
       
        $sink->attrib ("write" => $mesg . "\n");
        
	$text->attrib ("text" => "");
      }

      sub sethost
      {
        my $sink = enode ("csink.mysink");
	my $entry = enode ("entry.remote-host");
	$sink->attrib ("hostname", $entry->attrib ("text"));
      }

      sub setport
      {
        my $sink = enode ("csink.mysink");
        my $entry = enode ("entry.remote-port");
        $sink->attrib ("port" => $entry->attrib ("text"));
      }

    ]]>
  </perl>

</object>
