/*
                      Endeavour Pointer Cursors
 */

#ifndef EDV_CURSOR_H
#define EDV_CURSOR_H

#include <gtk/gtk.h>


typedef struct _edv_cursor_struct	edv_cursor_struct;
#define EDV_CURSOR(p)	((edv_cursor_struct *)(p))


/*
 *      Cursor Codes:
 *
 *	Each edv_cursor_code refers to an index in the cursors list
 *	on the edv_core_struct (see endeavour2.h).
 */
typedef enum {
	EDV_CURSOR_CODE_BUSY,
	EDV_CURSOR_CODE_PASSIVE_BUSY,
	EDV_CURSOR_CODE_TEXT,
	EDV_CURSOR_CODE_HAND,
	EDV_CURSOR_CODE_TRANSLATE,
	EDV_CURSOR_CODE_RESIZE,
	EDV_CURSOR_CODE_CROSSHAIR,
	EDV_CURSOR_CODE_INVISIBLE
} edv_cursor_code;


/*
 *	Cursor:
 */
struct _edv_cursor_struct {

	edv_cursor_code	code;
	GdkCursor	*cursor;

};


extern edv_cursor_struct *EDVCursorNew(
	const edv_cursor_code code, GdkCursor *gdk_cursor
);
extern edv_cursor_struct *EDVCursorNewGDKPreset(
	const edv_cursor_code code, const GdkCursorType gdk_cursor_type
);
extern void EDVCursorDelete(edv_cursor_struct *cursor);


#endif	/* EDV_CURSOR_H */
