/*
                            Configuration Fetching
 */

#ifndef EDVGET_H
#define EDVGET_H

#include <glib.h>
#include "edvcontext.h"

/*
 *	Returns a list of parameters.
 *
 *	The calling function must deallocate the returned pointer array
 *	and each string.
 */
extern gchar **EDVGetConfigurationParameters(
	edv_context_struct *ctx, gint *total
);
#define EDVGetConfigParams	EDVGetConfigurationParameters
#define EDVGetConfigParms	EDVGetConfigurationParameters

/*
 *	Gets the integer value of the given parameter.
 *
 *	This function does not distinguish error returns.
 */
extern gint EDVGetI(edv_context_struct *ctx, const gchar *parm);

/*
 *      Gets the long integer value of the given parameter.
 *
 *      This function does not distinguish error returns.
 */
extern glong EDVGetL(edv_context_struct *ctx, const gchar *parm);

/*
 *      Gets the unsigned long integer value of the given parameter.
 *
 *      This function does not distinguish error returns.
 */
extern gulong EDVGetUL(edv_context_struct *ctx, const gchar *parm);

/*
 *      Gets the float value of the given parameter.
 *
 *      This function does not distinguish error returns.
 */
extern gfloat EDVGetF(edv_context_struct *ctx, const gchar *parm);

/*
 *      Gets the double value of the given parameter.
 *
 *      This function does not distinguish error returns.
 */
extern gdouble EDVGetD(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the string value of the given parameter.
 *
 *	The returned pointer must not be modified or deallocated.
 *
 *	Can return NULL if the parameter does not exist.
 */
extern gchar *EDVGetS(edv_context_struct *ctx, const gchar *parm);

/*
 *      Convience function to return the version of Endeavour found
 *      in the configuration.
 *
 *      Note that this gives the version of Endeavour last recorded
 *      on the configuration file, not always the currently installed
 *      version.
 *
 *      Returns TRUE on success or FALSE on error.
 */
extern gboolean EDVGetVersion(
	edv_context_struct *ctx,
	gint *major, gint *minor, gint *release
);

#endif	/* EDVGET_H */
