/*
		     Endeavour MIME Types File IO
 */

#ifndef EDVMIMETYPESFIO_H
#define EDVMIMETYPESFIO_H

#include <glib.h>
#include "edvmimetypes.h"


/* Mailcap format import/export */
extern void EDVMimeTypeListMailcapImport(
	const gchar *filename,
	edv_mimetype_struct ***list, gint *total,
	gint insert_index,
	gboolean update, gboolean only_newer,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data,
	void (*added_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer added_data,
	void (*modified_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer modified_data
);
extern void EDVMimeTypeListMailcapExport(
	const gchar *filename,
	edv_mimetype_struct **list, gint total,
	gboolean include_read_only,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data
);

/* Media Types format import/export */
extern void EDVMimeTypeListMediaTypesImport(
	const gchar *filename,
	edv_mimetype_struct ***list, gint *total,
	gint insert_index,
	gboolean update, gboolean only_newer,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data,
	void (*added_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer added_data,
	void (*modified_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer modified_data
);
extern void EDVMimeTypeListMediaTypesExport(
	const gchar *filename,
	edv_mimetype_struct **list, gint total,
	gboolean include_read_only,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data
);

/* Endeavour MIME Types format reading and writing */
extern void EDVDMimeTypesListLoadFromSystem(
	edv_mimetype_struct ***list, gint *total,
	gint insert_index,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data,
	void (*added_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer added_data,
	gboolean mark_all_loaded_read_only
);
extern void EDVMimeTypeListLoadFromFile(
	const gchar *filename,
	edv_mimetype_struct ***list, gint *total,
	gint insert_index,
	gboolean update, gboolean only_newer,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data,
	void (*added_cb)(gpointer, gint, edv_mimetype_struct *),
	gpointer added_data,
	gboolean mark_all_loaded_read_only
);
extern void EDVMimeTypeListSaveToFile(
	const gchar *filename,
	edv_mimetype_struct **list, gint total,
	gboolean include_read_only,
	gint (*progress_cb)(gpointer, gulong, gulong),
	gpointer progress_data
);


#endif	/* EDVMIMETYPESFIO_H */
