C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE CREXTB(KSEC1,KERR)
C
C**** *CREXTB*
C
C
C     PURPOSE.
C     --------
C          Load Crex table B and  D  according to Edition and version
C     of Crex code.
C
C
C**   INTERFACE.
C     ----------
C
C          *CALL* *CREXTB(KSEC1,KERR)*
C
C        OUTPUT:
C               *KSEC1*   -  Integer array of at least 40 words
C                            containing CREX section 1 information
C                            KSEC1( 1)-- Reserved
C                            KSEC1( 2)-- CREX Edition number
C                            KSEC1( 3)-- Reserved
C                            KSEC1( 4)-- Reserved
C                            KSEC1( 5)-- Reserved
C                            KSEC1( 6)-- CREX message type
C                            KSEC1( 7)-- Reserved
C                            KSEC1( 8)-- version number of local table used
C                            KSEC1( 9)-- Reserved
C                            KSEC1(10)-- Reserved
C                            KSEC1(11)-- Reserved
C                            KSEC1(12)-- Reserved
C                            KSEC1(13)-- Reserved
C                            KSEC1(14)-- CREX Master table
C                            KSEC1(15)-- version number of Master table used
C                            KSEC1(16) - KSEC1(40) -- Reserved
C
C                            Crex Edition 2
C
C               *KSEC1*   -  Integer array of at least 40 words
C                            containing CREX section 1 information
C                            KSEC1( 1)-- Reserved
C                            KSEC1( 2)-- CREX Edition number
C                            KSEC1( 3)-- Originating Centre ( oooo)
C                            KSEC1( 4)-- Update sequence number (uu)
C                            KSEC1( 5)-- Number of subsets (sss)
C                            KSEC1( 6)-- CREX data category (nnn)
C                            KSEC1( 7)-- International data sub-category (mmm)
C                            KSEC1( 8)-- version number of local table used
C                            KSEC1( 9)-- Year (yyyy)
C                            KSEC1(10)-- Month (mm)
C                            KSEC1(11)-- Day (dd)
C                            KSEC1(12)-- Hour (hh)
C                            KSEC1(13)-- Minute (mm)
C                            KSEC1(14)-- CREX Master table (tt)
C                            KSEC1(15)-- version number of Master table used (vv)
C                            KSEC1(16)-- Originating sub-centre (ppp)
C                            KSEC1(17)-- Bufr master table version number
C                            KSEC1(18)-- Bufr version number of local table used
C                            KSEC1(19) - KSEC1(40) -- Reserved
C

C               *KERR*    -  returned error code
C
C     METHOD.
C     -------
C
C          NONE.
C
C
C     EXTERNALS.
C     ----------
C
C          NONE.
C
C     REFERENCE.
C     ----------
C
C          NONE.
C
C     AUTHOR.
C     -------
C
C          MILAN DRAGOSAVAC    *ECMWF*       07/01/2004.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
C
C
      PARAMETER(JSUP =   9,JSEC0=   3,JSEC1= 40,JSEC2= 64 ,JSEC3=    4,
     1          JSEC4=   2,JELEM=40000,JSUBS=400,JCVAL=150 ,JBUFL=40000,
     2          JBPW =  32,JTAB =3000,JCTAB=120,JCTST=1800,JCTEXT= 200,
     3          JWORK=360000,JKEY=46)
C
      PARAMETER(JP=3000,JL=20)
C
      COMMON/CREXTAB/ NCREXBR(JTAB),NCREXBS(JTAB)    , NCREXBDW(JTAB),
     1                NCREXDR(JTAB),NCREXDST(JTAB)   ,
     2                NCREXDL(JTAB),NCREXDSQ(JTAB*20),NCREXP(64,255)

C
C             NCREXBR     - table B,  table reference              array
C             NCREXBS     - table B,  scale                        array
C             NCREXBDW    - table B,  data width                   array
C             NCREXDR     - table D,  table reference              array
C             NCREXDST    - table D,  starting pointers            array
C             NCREXDL     - table D,  lengths                      array
C             NCREXDSQ    - table D,  list of sequence descriptors array
C
       COMMON/CREXTABC/ CREXNAME(JTAB),CREXUNIT(JTAB),CREXLST(JELEM)
C
C             CREXNAME      -  table B, ELEMENT NAME           array
C             CREXUNIT      -  table B, unit                   array
C
C
      COMMON /CREXROOT/ CROOT
C
C            croot    -  path for Crex tables
C
      CHARACTER*64 CREXNAME
      CHARACTER*24 CREXUNIT
      character*6  CREXLST
C
      CHARACTER*256 YNAME
      CHARACTER*256  YFNAME
      CHARACTER*160 YENTRY
C
      CHARACTER*256 YTAB ,YTAC ,YTAD
      CHARACTER*7  YTABB,YTABC,YTABD
      CHARACTER*256 CROOT
      CHARACTER*6 CNCREXBR
C
      DIMENSION KSEC1(*)
C
      INTEGER IEMOSNUM
C     EXTERNAL FUNCTIONS
C
      INTEGER EMOSNUM
      EXTERNAL EMOSNUM

      SAVE OFIRST
C
C     ------------------------------------------------------------------
C
C*          1.   GET CREX TABLES/LOCAL CREX TABLES.
C                ----------------------------------
 100  CONTINUE
C
      IF( KERR.NE.0) RETURN
C
C
C*          2.   SET UP CREX TABLE FILE NAME.
C                ----------------------------
 200  CONTINUE
C
C
C             CREX EDITION 1 NAMING CONVENTION
C
C             BXXYYZZ , DXXYYZZ
C
C             B      - CREX TABLE 'B'
C             D      - CREX TABLE 'D'
C             XX     - Crex Master table used '00'
C             YY     - Crex Edition number used '01'
C             ZZ     - Crex Table version number '01'
C
            IXX=0
            IYY=KSEC1( 2)
            IZZ=KSEC1(15)
C
         IF(OFIRST) THEN
            IF(IXX.EQ.NXXP.AND.IYY.EQ.NYYP.AND.
     1         IZZ.EQ.NZZP) RETURN
         END IF
C
      J=0
      ICLASS0=0
      IVIND=2147483647
C
      DO 101 I=1,64
      DO 101 II=1,255
       NCREXP(I,II)=0
 101  CONTINUE
C
      DO 102 i=1,JP
       NCREXBR(I)=IVIND
       NCREXBS (I)=IVIND
       NCREXBDW(I)=IVIND
       CREXNAME(I)=' '
       CREXUNIT(I)=' '
 102  CONTINUE
C
      J  =0
      IST=1
C
      DO 103 I=1,JP
       NCREXDR(I)=999999
       NCREXDL (I)=0
       NCREXDST(I)=0
 103  CONTINUE
C
      DO 104 I=1,JP*20
       NCREXDSQ(I)=0
 104  CONTINUE

      OFIRST=.TRUE.
C
      NXXP=IXX
      NYYP=IYY
      NZZP=IZZ
C
      WRITE(YTABB,'(A1,I2.2,I2.2,I2.2)') 'B',IXX,IYY,IZZ
C     WRITE(YTABC,'(A1,I2.2,I2.2,I2.2)') 'C',IXX,IYY,IZZ
      WRITE(YTABD,'(A1,I2.2,I2.2,I2.2)') 'D',IXX,IYY,IZZ
C
      PRINT*,'CREX Tables to be loaded ',YTABB,',',YTABD
C
C     ----------------------------------------------------------------
C*          3. OPEN AND READ FILES CONTAINING CREX TABLES.
C              -------------------------------------------
 300  CONTINUE
C
      CROOT=' '
      CALL GETENV('CREX_TABLES',CROOT)
      ILNG=INDEX(CROOT,' ')
      IF(ILNG.EQ.1) THEN
C
C       SGI/HP/SUN CREX TABLES PATH
C
        CROOT='/home/ma/emos/tables/crex/'
C
C       ADD VERSION NUMBER
C
        ILNG=INDEX(CROOT,' ')
        IEMOSNM = EMOSNUM(1)
        WRITE(CROOT(ILNG:ILNG+5),'(I6.6)') IEMOSNM
        CROOT(ILNG+6:) = '/'
      ENDIF

      I=INDEX(CROOT,' ')
      IF(I.NE.0) I=I-1
C
C*          3.1 READ CREX TABLE B.
C               ------------------
 310  CONTINUE
C
      YTAB=CROOT(1:I)//YTABB
      II=I+7
C
      OPEN(UNIT=38,IOSTAT=IOS,ERR=311,FILE=YTAB(1:II),
     1     FORM='FORMATTED',
     2     recl=160,
     5     STATUS='OLD')
C
      J=0
      GO TO 312
C
 311  CONTINUE
C
      CLOSE(38)
C
      KERR=9
      CALL CREXERR(KERR)
      print*,'Open error on ',YTAB(1:II)
C
      RETURN

C
 312  CONTINUE
C
      J=J+1
      READ(38,ERR=400,IOSTAT=IOS,END=329,
     1  FMT='(1x,A,1x,A64,47x,A24,I3,7x,I3)')
     2  CNCREXBR,CREXNAME(J),CREXUNIT(J),NCREXBS(J),NCREXBDW(J)
      IF(IOS.NE.0) THEN
         print*,'Internal read error.'
         print*,CNCREXBR
         KERR=35
         CALL CREXERR(KERR)
         RETURN
      END IF

C
      CNCREXBR(1:1)='0'
C
      READ(CNCREXBR,'(i6.6)',IOSTAT=IOS) NCREXBR(J)
      IF(IOS.NE.0) THEN
         print*,'Internal read error.'
         print*,CNCREXBR
         KERR=35
         CALL CREXERR(KERR)
         RETURN
      END IF
C
C
      ICLASS=NCREXBR(J)/1000
      IYYY  =NCREXBR(J)-ICLASS*1000+1
C
      ICLASS=ICLASS+1
      NCREXP(ICLASS,IYYY)=J

      GO TO 312
C
 329  CONTINUE
C
      CLOSE(UNIT=38,IOSTAT=IOS,ERR=420)
C
C*          3.3 READ CREX TABLE D.
C               ------------------
 330  CONTINUE
C
      YTAD=CROOT(1:I)//YTABD
C
      OPEN(UNIT=40,IOSTAT=IOS,ERR=331,FILE=YTAD(1:II),
     1     FORM='FORMATTED',
     2     recl=160,
     5     STATUS='OLD')
C
      GO TO 332
C
 331  CONTINUE
C
      CLOSE(40)
C
      print*,'Open error on ',YTAD
C
      KERR=9
      CALL CREXERR(KERR)
      RETURN
C
 332  CONTINUE
C
      J=0
 340  CONTINUE
c
      YENTRY=' '
      READ(40,'(A)',IOSTAT=IOS,END=390) YENTRY
      IF(IOS.NE.0) THEN
         print*,'Read error on CREX table D.'
         KERR=35
         CALL CREXERR(KERR)
         RETURN
      END IF
      IF(YENTRY(2:2).EQ.'D') YENTRY(2:2)='3'
c
      j=j+1
      READ(YENTRY,'(1X,I6,1X,I2)',IOSTAT=IOS) NCREXDR(J),NCREXDL(J)
      IF(IOS.NE.0) THEN
         print*,YENTRY
         KERR=35
         CALL CREXERR(KERR)
         RETURN
      END IF
      IF(J.GT.JP) THEN
         PRINT*,' DIMENSION TOO SMALL J=',J
         KERR=13
         RETURN
      END IF
C
      IF(J.EQ.1) THEN
         IST=1
         NCREXDST(J)=IST
      ELSE
         IST=IST + NCREXDL(J-1)
         NCREXDST(J)=IST
      END IF
C
      IF(NCREXDL(J).GT.1) THEN
         if(YENTRY(12:12).eq.'D') YENTRY(12:12)='3'
         if(YENTRY(12:12).eq.'C') then
            YENTRY(12:12)='2'
c           check if negative scale is present
            IMINUS=0
            IMINUS=INDEX(YENTRY(12:16),'-')
            IF(IMINUS.NE.0) YENTRY(IMINUS:IMINUS)='9'
         end if
         IF(YENTRY(12:12).eq.'R') YENTRY(12:12)='1'
         IF(YENTRY(12:12).eq.'B') YENTRY(12:12)='0'
         READ(YENTRY,'(11X,I6)',IOSTAT=IOS) NCREXDSQ(IST)
         IF(IOS.NE.0) THEN
            print*,YENTRY
            KERR=35
            CALL CREXERR(KERR)
            RETURN
         END IF
c
         IIST=IST
C
         DO 220 JA=1,NCREXDL(J)-1
         IIST=IIST+1
         READ(40,'(A)',END=300,IOSTAT=IOS) YENTRY
         IF(IOS.NE.0) THEN
            print*,YENTRY
            KERR=35
            CALL CREXERR(KERR)
            RETURN
         END IF
c
         IF(YENTRY(12:12).eq.'D') YENTRY(12:12)='3'
         IF(YENTRY(12:12).eq.'C') YENTRY(12:12)='2'
         IF(YENTRY(12:12).eq.'R') YENTRY(12:12)='1'
         IF(YENTRY(12:12).eq.'B') YENTRY(12:12)='0'
         READ(YENTRY,'(11X,I6)',IOSTAT=IOS) NCREXDSQ(IIST)
         IF(IOS.NE.0) THEN
            print*,'Internal read error.'
            print*,YENTRY
            KERR=35
            CALL CREXERR(KERR)
            RETURN
         END IF
 220     CONTINUE
C
      ELSE
         IF(YENTRY(12:12).eq.'D') YENTRY(12:12)='3'
         IF(YENTRY(12:12).eq.'C') YENTRY(12:12)='2'
         IF(YENTRY(12:12).eq.'R') YENTRY(12:12)='1'
         IF(YENTRY(12:12).eq.'B') YENTRY(12:12)='0'
         READ(YENTRY,'(11X,I6)',IOSTAT=IOS) NCREXDSQ(IST)
         IF(IOS.NE.0) THEN
            print*,YENTRY
            KERR=35
            CALL CREXERR(KERR)
            RETURN
         END IF
      END IF
C
      GO TO 340
c
 390  CONTINUE
C
      CLOSE(UNIT=40,IOSTAT=IOS,ERR=620)
C
C
      RETURN
C     ----------------------------------------------------------------
 400  CONTINUE
C
      KERR=6
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 410  CONTINUE
C
      KERR=9
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 420  CONTINUE
C
      KERR=10
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C     ----------------------------------------------------------------
 500  CONTINUE
C
      KERR=7
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 510  CONTINUE
C
      KERR=9
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 520  CONTINUE
C
      KERR=11
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C     -----------------------------------------------------------------
 600  CONTINUE
C
      KERR=8
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 610  CONTINUE
C
      KERR=9
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C
 620  CONTINUE
C
      KERR=12
      PRINT*,'BUGBTS: IOS ',IOS
      CALL CREXERR(KERR)
      OFIRST=.FALSE.
      RETURN
C     -----------------------------------------------------------------
C
      END
