/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------
   
   An implementation of hooks.
   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include "hook.h"
#include "xmalloc.h"
#include "run.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/


hook_t *
hook_create (void (*action)(void))
{
        hook_t *result = xmalloc (sizeof (hook_t));
        result->action = action;
        result->prog   = NULL;
        result->next   = NULL;
        return result;
}


hook_t *
hook_create_prog (char *prog)
{
        hook_t *result = xmalloc (sizeof (hook_t));
        result->action = NULL;
        result->prog   = prog;
        result->next   = NULL;
        return result;
}
        


hook_t *
hook_make_copy (hook_t *hook)
{
        hook_t *result;
        
        if (hook == NULL)
                return NULL;

        result         = xmalloc (sizeof (hook_t));
        result->action = hook->action;
        result->prog   = hook->prog;
        result->next   = hook_make_copy (hook->next);
        return result;
}



hook_t *
hook_add (hook_t *hook, void (*action)(void))
{
        hook_t *result = hook;
        
        if (result == NULL){
                result = hook_create (action);
        }
        else {
                while (hook->next)
                        hook = hook->next;
                hook->next = hook_create (action);
        }
        return result;
}


hook_t *
hook_add_prog (hook_t *hook, char *prog)
{
        hook_t *result = hook;

        if (result == NULL){
                result = hook_create_prog (prog);
        }
        else {
                while (hook->next)
                        hook = hook->next;
                hook->next = hook_create_prog (prog);
        }
        return result;
}


hook_t *
hook_copy (hook_t *hook, hook_t *orig)
{
        hook_t *result = hook;

        if (result == NULL){
                result = hook_make_copy (orig);
        }
        else {
                while (hook->next)
                        hook = hook->next;
                hook->next = hook_make_copy (orig);
        }
        return result;
}


void
hook_destroy (hook_t *hook)
{
        hook_t *tmp;

        if (hook == NULL)
                return;
  
        hook = hook->next;
        while (hook){
                tmp = hook->next;
                if (hook->prog)
                        xfree (hook->prog);
                xfree (hook);
                hook = tmp;
        }
}


void
hook_execute (hook_t *hook)
{
        while (hook){
                if (hook->action)
                        hook->action ();
                else if (hook->prog)
                        run (hook->prog);
                hook = hook->next;
        }
}


/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE hook.c
 *
 ****************************************************************************/
