/*
 *  Copyright (C) 2001-2002 Hewlett-Packard Co.
 *	Contributed by Stephane Eranian <eranian@hpl.hp.com>
 *
 * This file is part of the ELILO, the EFI Linux boot loader.
 *
 *  ELILO is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  ELILO is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ELILO; see the file COPYING.  If not, write to the Free
 *  Software Foundation, 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 *
 * Please check out the elilo.txt for complete documentation on how
 * to use this program.
 */
#include <efi.h>
#include <efilib.h>

#include "fs/localfs.h"
#include "glue_localfs.h"
#include "strops.h"

static INTN glue(fileops_t *this, VOID *intf);

/* object exported to fileops */

fileops_fs_t localfs_glue = { LOCALFS_PROTOCOL, glue, localfs_install, localfs_uninstall};

/*
 * The following glue functions are the only ones which need
 * to know about the way the underlying interface is working
 */
#define LOCALFS_DEFAULT_KERNEL	L"vmlinux"
#define LOCALFS_DEFAULT_CONFIG	L"elilo.conf"
static EFI_STATUS
localfs_setdefaults(VOID *this, CHAR16 *config, CHAR16 *kname, UINTN maxlen)
{
	StrnCpy(kname, LOCALFS_DEFAULT_KERNEL, maxlen-1);
	kname[maxlen-1] = CHAR_NULL;

	StrnCpy(config, LOCALFS_DEFAULT_CONFIG, maxlen-1);
	config[maxlen-1] = CHAR_NULL;

	return EFI_SUCCESS;
}

/*
 * convert forward slashes into backward slashes
 * and will not touched strings with backward slashes
 */
static EFI_STATUS 
glue_open(VOID *intf, CHAR16 *name, fops_fd_t *fd)
{
#define	CHAR_SLASH	L'/'
#define CHAR_BACKSLASH	L'\\'
	CHAR16 *p;
	localfs_interface_t *localfs = (localfs_interface_t *)intf;

	for (p=name; *p != CHAR_NULL; p++) {
		if (*p == CHAR_SLASH) *p = CHAR_BACKSLASH;
	}
	return localfs->localfs_open(intf, name, fd);
}

static INTN
glue(fileops_t *fp, VOID *intf)
{
	localfs_interface_t *localfs = (localfs_interface_t *)intf;

	fp->open        = glue_open;
	fp->read        = (fops_read_t)localfs->localfs_read;
	fp->close       = (fops_close_t)localfs->localfs_close;
	fp->infosize    = (fops_infosize_t)localfs->localfs_infosize;
	fp->seek        = (fops_seek_t)localfs->localfs_seek;
	fp->setdefaults = (fops_setdefaults_t)localfs_setdefaults;
	fp->intf	= intf;

	/* fill out the name of the underlying file system */
	localfs->localfs_name(localfs, fp->name, FILEOPS_NAME_MAXLEN);

	return 0;
}
