#!/bin/sh
# $Id: clp_gen.sh,v 2.13 2002/05/08 15:00:48 waite Exp $
# Copyright, 1990, The University of Colorado
# Copyright, 1995-1999, Anthony M. Sloane

# This file is part of the Eli translator construction system.

# Eli is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.

# Eli is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# You should have received a copy of the GNU General Public License along
# with Eli; see the file COPYING.  If not, write to the Free Software
# Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# EXEC (clp_gen.sh) (.) (:clp.cmpd :cpp)
#   NEEDS (clp.exe) (clp.err) ($ODINCACHE/PKGS/skeleton/sed.exe)
#   => (:clp_gen);
# 
# :clp_gen 'Objects generated from CLP specifications' => :DERIVED-DIRECTORY;

PKG=$1;shift; ODIN_cmpd=$1;shift;  mkdir clp_gen;
SED=$ODINCACHE/PKGS/skeleton/sed.exe

# put the clp comment indicator '%' in front of cpp control lines
$SED -e '/^#/s/^/%/' "$ODIN_cmpd" > INFILE

# run the clp compiler
("$PKG/clp.exe" INFILE || echo 'CLP compiler failed') \
    >ERROR 2>&1
if test -s ERROR
then
    echo '(|'"$PKG/clp.err"'|std_err|' > ERRORS
    echo '(|'"$ODIN_cmpd"'|line_err|' >> ERRORS
    $SED \
        's/^"\([^"]*\)", line \([0-9]*\):\([0-9]*\)/\1 \2 \3/' ERROR >>ERRORS
    echo '|)' >> ERRORS
    echo '|)' >> ERRORS
    exit 0
else :
fi

# generated components
mv clp.c clp.h clp_gen

