# titan.core

TTCN-3 is a standardized, modular language specifically designed for testing. 
Eclipse Titan offers a free and open source (FOSS) compiler both for TTCN-3 and for 
ASN.1 (Abstract Syntax Notation One).

# Standards page (also including downloadable code):

* http://www.ttcn-3.org/

# Main project page:

* https://projects.eclipse.org/projects/tools.titan

# Community forum:

* https://www.eclipse.org/forums/index.php/f/297/

##Introductory video of a presentation about Titan held at EclipseCon 2014: 
* https://www.youtube.com/watch?v=2knzZuwzn-Y.

##Titan Datasheet on polarsys.org:
http://polarsys.org/sites/default/files/custom_uploads/TITAN%20Datasheet%20A4%202.1.pdf

## Ericsson TTCN-3 Course, Presentation material
http://www.ttcn-3.org/files/TTCN3_P.pdf

## Ericsson TTCN-3 Course, Presentation material, part II (Titan specifics)
https://www.eclipse.org/downloads/download.php?file=/titan/TITAN_User_P.pdf




##Binaries and SHA512 checksums for a number of Linux platforms can be downloaded from:


* https://projects.eclipse.org/projects/tools.titan/downloads


# Related products:

##Eclipse IDE plug-ins (Designer, Executor, LogViewer, Titanium):

Source code:

* https://github.com/eclipse/titan.EclipsePlug-ins

Compressed update site and SHA512 checksum:

* https://projects.eclipse.org/projects/tools.titan/downloads
 
## Test Ports:
 
* https://github.com/eclipse/titan.TestPorts.Common_Components.Abstract_Socket
* https://github.com/eclipse/titan.TestPorts.Common_Components.Socket-API
* https://github.com/eclipse/titan.TestPorts.HTTPmsg
* https://github.com/eclipse/titan.TestPorts.IPL4asp
* https://github.com/eclipse/titan.TestPorts.LANL2asp
* https://github.com/eclipse/titan.TestPorts.LDAPasp_RFC4511
* https://github.com/eclipse/titan.TestPorts.LDAPmsg
* https://github.com/eclipse/titan.TestPorts.PCAPasp
* https://github.com/eclipse/titan.TestPorts.PIPEasp
* https://github.com/eclipse/titan.TestPorts.SCTPasp
* https://github.com/eclipse/titan.TestPorts.SIPmsg
* http://git.eclipse.org/gitroot/titan/titan.TestPorts.SocketCANasp
* https://github.com/eclipse/titan.TestPorts.SQLasp
* https://github.com/eclipse/titan.TestPorts.SSHCLIENTasp
* https://github.com/eclipse/titan.TestPorts.STDINOUTmsg
* https://github.com/eclipse/titan.TestPorts.SUNRPCasp
* https://github.com/eclipse/titan.TestPorts.TCPasp
* https://github.com/eclipse/titan.TestPorts.TELNETasp
* https://github.com/eclipse/titan.TestPorts.UDPasp
* https://github.com/eclipse/titan.TestPorts.UNIX_DOMAIN_SOCKETasp
 
 
## Protocol Modules:
 
* https://github.com/eclipse/titan.ProtocolModules.COMMON  
* https://github.com/eclipse/titan.ProtocolModules.DHCP
* https://github.com/eclipse/titan.ProtocolModules.DHCPv6
* https://github.com/eclipse/titan.ProtocolModules.DIAMETER_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.DNS
* https://github.com/eclipse/titan.ProtocolModules.FrameRelay
* https://github.com/eclipse/titan.ProtocolModules.H248_v2
* https://github.com/eclipse/titan.ProtocolModules.HTTP2.0
* https://github.com/eclipse/titan.ProtocolModules.ICAP
* https://github.com/eclipse/titan.ProtocolModules.ICMP
* https://github.com/eclipse/titan.ProtocolModules.ICMPv6
* https://github.com/eclipse/titan.ProtocolModules.IKEv2
* https://github.com/eclipse/titan.ProtocolModules.IMAP_4rev1
* https://github.com/eclipse/titan.ProtocolModules.IP
* https://github.com/eclipse/titan.ProtocolModules.IPsec
* https://github.com/eclipse/titan.ProtocolModules.IUA
* https://github.com/eclipse/titan.ProtocolModules.JSON_v07_2006
* https://github.com/eclipse/titan.ProtocolModules.L2TP
* https://github.com/eclipse/titan.ProtocolModules.M3UA
* https://github.com/eclipse/titan.ProtocolModules.MIME
* https://github.com/eclipse/titan.ProtocolModules.MSRP
* https://github.com/eclipse/titan.ProtocolModules.PPP
* https://github.com/eclipse/titan.ProtocolModules.ProtoBuff
* https://github.com/eclipse/titan.ProtocolModules.RADIUS_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.RTP
* https://github.com/eclipse/titan.ProtocolModules.RTSP
* https://github.com/eclipse/titan.ProtocolModules.SMPP
* https://github.com/eclipse/titan.ProtocolModules.SMTP
* https://github.com/eclipse/titan.ProtocolModules.SNMP
* https://github.com/eclipse/titan.ProtocolModules.SRTP
* https://github.com/eclipse/titan.ProtocolModules.TCP
* https://github.com/eclipse/titan.ProtocolModules.UDP
* https://github.com/eclipse/titan.ProtocolModules.WebSocket
* https://github.com/eclipse/titan.ProtocolModules.XMPP
* http://git.eclipse.org/gitroot/titan/titan.ProtocolModules.CoAP
* http://git.eclipse.org/gitroot/titan/titan.ProtocolModules.MQTT

## Libraries:

* https://github.com/eclipse/titan.Libraries.TCCUsefulFunctions

## Miscellaneous projects: 

* https://github.com/eclipse/titan.misc
(VSBOT, SIP_ETSI,DIAMETER_Rx_ETSI, CoAP Conformance test cases,  CoAP and MQTT protocol modules for IOT-moved to Eclipse git,  more to come...) 
