/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dsyslog.h"

static gboolean
dsyslog_source_mark_timer_cb(gpointer unused)
{
	time_t now = time(NULL);
	static char datebuf[400];
	struct tm *tm;

	_ENTER;

	tm = localtime(&now);
	strftime(datebuf, sizeof datebuf, "%b %e %T", tm);

	dsyslog_event_dispatch(87, datebuf, NULL, "dsyslog", "-- MARK --");

	_LEAVE TRUE;
}

static void
dsyslog_source_mark_delete(dsyslog_source_t *src)
{
	_ENTER;

	g_source_remove(GPOINTER_TO_INT(src->opaque));

	_LEAVE;
}

static void
dsyslog_source_mark_new(dsyslog_source_t *src)
{
	_ENTER;

	src->opaque = GINT_TO_POINTER(g_timeout_add_seconds(1800, dsyslog_source_mark_timer_cb, NULL));
	src->destructor = dsyslog_source_mark_delete;

	_LEAVE;
}

void
_modinit(void)
{
	_ENTER;

	dsyslog_source_register("mark", dsyslog_source_mark_new);

	_LEAVE;
}

void
_modfini(void)
{
	_ENTER;

	dsyslog_source_unregister("mark");

	_LEAVE;
}
