/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 * Copyright 2002-2003 Todd Kulesza
 * Copyright 2009 Neil Williams  <linux@codehelp.co.uk>
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 * 		Neil Williams  <linux@codehelp.co.uk>
 */

#include <config.h>

#include <glib/gi18n.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <string.h>

#include "about.h"

void
about_show (DrivelClient *dc)
{
	GdkPixbuf *logo;
	static GtkWidget *dialog = NULL;
	static const gchar *main_authors[] =
	{
		"Todd Kulesza <todd@dropline.net>",
		"Davyd Madeley <davyd@ucc.asn.au>",
		"Neil Williams  <linux@codehelp.co.uk>",
		"",
		NULL
	};
	static const gchar *help_authors[] =
	{
		"Grahame Bowland <grahame@angrygoats.net>",
		"Geoff King <0glk@qlink.queensu.ca>",
		"Jess Little <jackymac@gmail.com>",
		"Evan Martin <evan@livejournal.com>",
		"Margot Pearce <cupidelock@gmail.com>",
		"Ari Pollak <compwiz@aripollak.com>",
		"Isak Savo <iso01001@student.mdh.se>",
		"Maxime DOYEN <homebank@free.fr>",
		"",
		NULL
	};
	static const gchar *documentors[] = 
	{
		"Todd Kulesza <todd@dropline.net>",
		NULL
	};
	/*
	 * Translators should localize the following string
	 * which will give them credit in the About box.
	 * E.g. "Fulano de Tal <fulano@detal.com>" */
	gchar *path, *translators = g_strdup (_("translator-credits"));
	gchar **authors;
	GString *s;
	gint i;

	if (dialog)
	{
		gtk_window_present (GTK_WINDOW (dialog));
		return;
	}
	/* This is necessary, since the N_(string)-macro doesn't actually do anything,
	   it's only used as an indicator for xgettext */
	s = g_string_new ("");
	for (i = 0; main_authors[i] != NULL; i++){
	  s = g_string_append (s, main_authors[i]);
	  s = g_string_append_c (s, '\n');
	}
	g_string_append_printf (s, "%s\n", _("With help from:"));
	for (i = 0; help_authors[i] != NULL; i++) {
	    s = g_string_append (s, help_authors[i]);
	    s = g_string_append_c (s, '\n');
	};
	g_string_append (s, _("And many others--thank you, all!"));
	authors = g_strsplit (s->str, "\n", -1);

	path = g_build_filename (DATADIR, "pixmaps", "drivel-48.png", NULL);
	logo = gdk_pixbuf_new_from_file (path, NULL);
	g_free (path);
	dialog = gtk_about_dialog_new ();
	gtk_about_dialog_set_version (GTK_ABOUT_DIALOG (dialog), VERSION);
	gtk_about_dialog_set_program_name (GTK_ABOUT_DIALOG (dialog), _("Drivel Journal Editor"));
	gtk_about_dialog_set_copyright (GTK_ABOUT_DIALOG (dialog),
		"Copyright 2002-2005 Todd Kulesza,\n Copyright 2009 Neil Williams");
	gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG (dialog),
		_("A journal client for the GNOME desktop."));
	gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG (dialog), (const gchar **) authors);
	gtk_about_dialog_set_documenters (GTK_ABOUT_DIALOG (dialog), documentors);
	gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (dialog), translators);
	gtk_about_dialog_set_logo (GTK_ABOUT_DIALOG (dialog), logo);
	gtk_about_dialog_set_website (GTK_ABOUT_DIALOG (dialog), "http://drivel.sourceforge.net/");
	gtk_about_dialog_set_website_label (GTK_ABOUT_DIALOG (dialog), _("Homepage:"));

	gtk_about_dialog_set_license (GTK_ABOUT_DIALOG (dialog),
		"  This package is free software; you can redistribute it and/or modify\n"
		"  it under the terms of the GNU General Public License as published by\n"
		"  the Free Software Foundation; either version 2 of the License, or\n"
		"  (at your option) any later version.\n"
		"\n"
		"  This program is distributed in the hope that it will be useful,\n"
		"  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"  GNU General Public License for more details.\n"
		"\n"
		"  You should have received a copy of the GNU General Public License\n"
		"  along with this program; if not, write to the Free Software\n"
		"  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,\n"
		"  MA 02110-1301, USA.\n");

	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (dc->current_window));
	
	g_object_add_weak_pointer (G_OBJECT (dialog), (void **)&dialog);
	
	gtk_dialog_run (GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
	
	g_free (translators);
	g_string_free (s, TRUE);
	g_strfreev (authors);
	
	return;
}
