from re import compile

from dosage.helpers import BasicScraper


class YouSayItFirst(BasicScraper):
    latestUrl = 'http://www.yousayitfirst.com/'
    imageUrl = 'http://www.soapylemon.com/comics/index.php?date=%s'
    imageSearch = compile(r'(http://.+?comics/.+?.jpg)[^<]')
    prevSearch = compile(r'(/comics/index.php\?date=.+?)".+?P')
    help = 'Index format: yyyymmdd'


class Yirmumah(BasicScraper):
    latestUrl = 'http://yirmumah.net/archives.php'
    imageUrl = 'http://yirmumah.net/archives.php?date=%s'
    imageSearch = compile(r'<img src="(strips/\d{8}\..*?)"')
    prevSearch = compile(r'<a href="(\?date=\d{8})">.*Previous')
    help = 'Index format: yyyymmdd'
