from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, indirectStarter


class TheNoob(BasicScraper):
    latestUrl = 'http://www.thenoobcomic.com/'
    imageUrl = 'http://www.thenoobcomic.com/daily/strip%s.html'
    imageSearch = compile(r'<img src="((\.\.)?/images/\d{8}\.jpg)"')
    prevSearch = compile(r'<a href="((/daily/)?strip\d+\.html)">Previous</a>')
    help = 'Index format: n (unpadded)'


class TheOrderOfTheStick(BasicScraper):
    latestUrl = 'http://www.giantitp.com/'
    imageUrl = 'http://www.giantitp.com/comics/images/%s'
    imageSearch = compile(r'<IMG src="(/comics/images/.+?)">')
    prevSearch = compile(r'<A href="(/comics/oots\d{4}\.html)"><IMG src="/Images/redesign/ComicNav_Back.gif"')
    help = 'Index format: n (unpadded)'
    starter = indirectStarter('http://www.giantitp.com/', compile(r'<A href="(/comics/oots\d{4}\.html)"'))


class TheParkingLotIsFull(BasicScraper):
    latestUrl = 'http://plif.andkon.com/archive/arch2002.htm'
    imageUrl = 'http://plif.andkon.com/archive/wc%s.gif'
    imageSearch = compile(r'<td align="center"><A TARGET=_parent HREF="(wc\d+\..+?)">')
    prevSearch = compile(r'-\s*\n\s*<A HREF="(arch\d{4}\.htm)">\d{4}</A>')
    help = 'Index format: nnn'


class TheWotch(BasicScraper):
    latestUrl = 'http://www.thewotch.com/'
    imageUrl = 'http://www.thewotch.com/?epDate=%s'
    imageSearch = compile(r"<img.+?src='(comics/.+?)'")
    prevSearch = compile(r"<link rel='Previous' href='(\?epDate=\d+-\d+-\d+)'")
    help = 'Index format: yyyy-mm-dd'


class TwoTwoOneFour(BasicScraper):
    latestUrl = 'http://www.nitrocosm.com/comic.php'
    imageUrl = 'http://www.nitrocosm.com/comic.php?page=%s'
    imageSearch = compile(r'<img src="(comic/\d{3}.+?)"')
    prevSearch = compile(r'<a href="(comic.php\?page=\d+)"><img src="http://www.nitrocosm.com/skins/07/back.gif"')
    help = 'Index format: n (unpadded)'


def theFray():
    class TheFray(BasicScraper):
        imageUrl = 'http://www.funnybonecomics.com/thefray/thefray_%s.shtml'
        imageSearch = compile(r'<img src="(images/archive/thefray_\d{8}\..+?)"')
        prevSearch = compile(r'<area href="(thefray_\d{8}\.shtml)" shape="rect" coords="[\d, ]+" alt="Previous">')
        help = 'Index format: yyyymmdd'

    comics = {
        'ThePreface': 'thepreface',
        'TheHole': 'thehole',
        }

    return dict((name, TheFray.make('TheFray/' + name, latestUrl='http://www.funnybonecomics.com/thefray/%s.html' % value)) for name, value in comics.iteritems())

globals().update(theFray())


class TheWhiteboard(BasicScraper):
    imageUrl = 'http://www.the-whiteboard.com/autowb%s.html'
    imageSearch = compile(r'<br><img SRC="(autowb.{1,4}\..+?)">', IGNORECASE)
    prevSearch = compile(r'<a href="(autowb.{1,4}\.html)">previous</a>', IGNORECASE)
    starter = indirectStarter('http://www.the-whiteboard.com/', prevSearch)
    help = 'Index format: n'
