import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin

class RedMeat(BasicComicModule, BounceMixin):
    baseUrl = 'http://www.redmeat.com/redmeat/current/index.html'
    imageUrl = 'http://www.redmeat.com/redmeat/%s/index.html'
    imageSearch = re.compile(r'<img src="(index-1\.gif)" width="\d+" height="\d+" alt="[^"]*" border="\d">')
    prevSearch = re.compile(r'<a href="(\.\./\d{4}-\d{2}-\d{2}/index\.html)">previous</a>')
    nextSearch = re.compile(r'<a href="(\.\./\d{4}-\d{2}-\d{2}/index\.html)">next</a>')
    help = 'Index format: yyyy-mm-dd'

    def getFilename(self, imageUrl, pageUrl):
        return imageUrl.split('/')[-2]
